/*
 * Decompiled with CFR 0.152.
 */
package com.github.anopensaucedev.fasterrandom.mixin;

import com.github.anopensaucedev.fasterrandom.FasterRandom;
import com.github.anopensaucedev.fasterrandom.util.jvm.JvmUtil;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FasterRandomMixinPlugin
implements IMixinConfigPlugin {
    @NotNull
    private static final Supplier<Boolean> TRUE = () -> true;
    @NotNull
    private static final Map<String, Supplier<Boolean>> CONDITIONS = ImmutableMap.of();
    private static boolean hasLoggedLoadingMessage = false;

    public boolean shouldApplyMixin(@NotNull String targetClassName, @NotNull String mixinClassName) {
        if (!JvmUtil.isRandomGeneratorFactorySupported()) {
            if (hasLoggedLoadingMessage) {
                return false;
            }
            @NotNull String warningMessage = String.format("Faster Random was unable to load!\nWARNING: Your Java Virtual Machine (JVM) does not implement RandomGeneratorFactory and/or L64X128MixRandom, which Faster Random requires to run.\nPlease use a supported JVM such as Azul Zulu (https://www.azul.com/downloads/#zulu) or GraalVM (https://www.graalvm.org/downloads/).\nYour JVM, %s version %s, is not suitable for Faster Random. Faster Random will disable itself.\n", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"));
            FasterRandom.LOGGER.warn(warningMessage);
            hasLoggedLoadingMessage = true;
            return false;
        }
        if (hasLoggedLoadingMessage) {
            return CONDITIONS.getOrDefault(mixinClassName, TRUE).get();
        }
        FasterRandom.LOGGER.info("Loading {}.", (Object)"Faster Random");
        hasLoggedLoadingMessage = true;
        return CONDITIONS.getOrDefault(mixinClassName, TRUE).get();
    }

    public void onLoad(String mixinPackage) {
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Nullable
    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

