/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.silverdungeon;

import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonRoom;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverFloorPiece;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverTemplePiece;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_5819;
import net.minecraft.class_6626;

public class SilverDungeonBuilder {
    private static final int CHEST_ROOM = 1;
    private static final int STAIRS = 2;
    private static final int FINAL_STAIRS = 4;
    private static final int STAIRS_MIDDLE = 8;
    private static final int STAIRS_TOP = 16;
    private static final int NORTH_DOOR = 32;
    private static final int WEST_DOOR = 64;
    private static final int VISITED = 128;
    private final class_5819 random;
    private final int[][][] grid;
    private final int width;
    private final int height;
    private final int length;

    public SilverDungeonBuilder(class_5819 random, int x, int y, int z) {
        this.random = random;
        this.grid = new int[x][y][z];
        this.width = x;
        this.height = y;
        this.length = z;
        this.populateGrid();
    }

    private void populateGrid() {
        int finalStairsX = this.random.method_43048(this.width);
        this.grid[finalStairsX][0][0] = 4;
        this.grid[finalStairsX][1][0] = 8;
        this.grid[finalStairsX][2][0] = 16;
        int firstStairsX = this.random.method_43048(this.width);
        this.grid[firstStairsX][0][1] = 2;
        this.grid[firstStairsX][1][1] = 16;
        int secondStairsX = this.random.method_43048(this.width);
        this.grid[secondStairsX][1][2] = 2;
        this.grid[secondStairsX][2][2] = 16;
        for (int y = 0; y < this.height; ++y) {
            this.traverseRooms(1, y, 1, 0);
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    if ((this.grid[x][y][z] & 0x1F) != 0 || this.random.method_43048(3) == 0) continue;
                    int[] nArray = this.grid[x][y];
                    int n = z;
                    nArray[n] = nArray[n] | 1;
                }
            }
        }
    }

    private boolean traverseRooms(int x, int y, int z, int typesToAvoid) {
        if (x < 0 || x >= this.width || z < 0 || z >= this.length) {
            return false;
        }
        int room = this.grid[x][y][z];
        if ((room & typesToAvoid) > 0) {
            return false;
        }
        if ((room & 0x80) == 128) {
            return this.random.method_43048(3) == 0;
        }
        int[] nArray = this.grid[x][y];
        int n = z;
        nArray[n] = nArray[n] | 0x80;
        int blacklist = this.setNeighborBlacklist(room);
        ArrayList directions = new ArrayList(4);
        Collections.addAll(directions, class_2350.field_11043, class_2350.field_11039, class_2350.field_11035, class_2350.field_11034);
        block6: for (int i = directions.size(); i > 0; --i) {
            int index = this.random.method_43048(i);
            switch ((class_2350)directions.remove(index)) {
                case field_11043: {
                    if (!this.traverseRooms(x, y, z - 1, blacklist)) continue block6;
                    int[] nArray2 = this.grid[x][y];
                    int n2 = z;
                    nArray2[n2] = nArray2[n2] | 0x20;
                    continue block6;
                }
                case field_11035: {
                    if (!this.traverseRooms(x, y, z + 1, blacklist)) continue block6;
                    int[] nArray3 = this.grid[x][y];
                    int n3 = z + 1;
                    nArray3[n3] = nArray3[n3] | 0x20;
                    continue block6;
                }
                case field_11039: {
                    if (!this.traverseRooms(x - 1, y, z, blacklist)) continue block6;
                    int[] nArray4 = this.grid[x][y];
                    int n4 = z;
                    nArray4[n4] = nArray4[n4] | 0x40;
                    continue block6;
                }
                case field_11034: {
                    if (!this.traverseRooms(x + 1, y, z, blacklist)) continue block6;
                    int[] nArray5 = this.grid[x + 1][y];
                    int n5 = z;
                    nArray5[n5] = nArray5[n5] | 0x40;
                }
            }
        }
        return true;
    }

    private int setNeighborBlacklist(int roomType) {
        int blacklist = 12;
        if ((roomType & 0x10) == 16) {
            blacklist |= 2;
        }
        if ((roomType & 2) == 2) {
            blacklist |= 0x10;
        }
        return blacklist;
    }

    public void assembleDungeon(class_6626 builder, class_3485 templateManager, class_2338 startPos, class_2470 rotation, class_2350 direction) {
        startPos = startPos.method_10069(direction.method_10165() * 5 - direction.method_10148(), 5, -direction.method_10148() * 5 - direction.method_10165());
        class_2338.class_2339 offset = new class_2338.class_2339();
        class_2470 sideways = rotation.method_10501(class_2470.field_11463);
        for (int y = this.height - 1; y >= 0; --y) {
            offset.method_33098(startPos.method_10264() + y * 5);
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    int xOffset = startPos.method_10263() + direction.method_10165() * x * 7 + direction.method_10148() * z * 7;
                    int zOffset = startPos.method_10260() + direction.method_10165() * z * 7 - direction.method_10148() * x * 7;
                    offset.method_10103(xOffset, offset.method_10264(), zOffset);
                    int room = this.grid[x][y][z];
                    builder.method_35462((class_3443)new SilverFloorPiece(templateManager, "floor", offset.method_10069(direction.method_10148() + direction.method_10165(), -1, direction.method_10165() - direction.method_10148()), rotation));
                    builder.method_35462((class_3443)new SilverTemplePiece(templateManager, (room & 0x20) == 32 ? "door" : "wall", offset.method_10069(direction.method_10165(), 0, -direction.method_10148()), rotation));
                    builder.method_35462((class_3443)new SilverTemplePiece(templateManager, (room & 0x40) == 64 ? "door" : "wall", offset.method_10093(direction), sideways));
                    if ((room & 4) == 4) {
                        builder.method_35462((class_3443)new SilverDungeonRoom(templateManager, "tall_staircase", offset.method_10069(2, 0, 2), rotation));
                        builder.method_35462((class_3443)new SilverTemplePiece(templateManager, "boss_door", offset.method_10069(direction.method_10165() * 3, 0, -direction.method_10148() * 3), rotation));
                        continue;
                    }
                    if ((room & 2) == 2) {
                        builder.method_35462((class_3443)new SilverDungeonRoom(templateManager, "staircase", offset.method_10069(2, 0, 2), rotation));
                        continue;
                    }
                    if ((room & 1) != 1) continue;
                    builder.method_35462((class_3443)new SilverDungeonRoom(templateManager, "chest_room", offset.method_10069(3, 0, 3), rotation));
                }
            }
        }
    }
}

