/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.mixin.mixins.common.accessor.ChunkAccessAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.SpreadingSnowyDirtBlockAccessor;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.processor.DoubleDropsProcessor;
import com.aetherteam.aether.world.processor.GlowstonePortalAgeProcessor;
import com.aetherteam.aether.world.processor.HolystoneReplaceProcessor;
import com.aetherteam.aether.world.processor.SurfaceRuleProcessor;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2541;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2802;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3470;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3542;
import net.minecraft.class_3754;
import net.minecraft.class_3773;
import net.minecraft.class_3793;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5873;
import net.minecraft.class_6378;
import net.minecraft.class_6568;
import net.minecraft.class_6625;
import net.minecraft.class_6686;
import org.slf4j.Logger;

public class GlowstoneRuinedPortalPiece
extends class_3470 {
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public GlowstoneRuinedPortalPiece(class_3485 structureTemplateManager, class_2338 templatePosition, VerticalPlacement verticalPlacement, Properties properties, class_2960 location, class_2470 rotation, class_2415 mirror, class_2338 pivotPos) {
        super((class_3773)AetherStructurePieceTypes.RUINED_PORTAL.get(), 0, structureTemplateManager, location, location.toString(), GlowstoneRuinedPortalPiece.makeSettings(mirror, rotation, pivotPos, properties), templatePosition);
        this.verticalPlacement = verticalPlacement;
        this.properties = properties;
    }

    public GlowstoneRuinedPortalPiece(class_3485 structureTemplateManager, class_2487 tag) {
        super((class_3773)AetherStructurePieceTypes.RUINED_PORTAL.get(), tag, structureTemplateManager, location -> GlowstoneRuinedPortalPiece.makeSettings(structureTemplateManager, tag, location));
        this.verticalPlacement = VerticalPlacement.byName(tag.method_10558("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Properties"))).getOrThrow(true, arg_0 -> ((Logger)Aether.LOGGER).error(arg_0));
    }

    public GlowstoneRuinedPortalPiece(class_6625 context, class_2487 tag) {
        this(context.comp_135(), tag);
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        super.method_14943(context, tag);
        tag.method_10582("Rotation", this.field_15434.method_15113().name());
        tag.method_10582("Mirror", this.field_15434.method_15114().name());
        tag.method_10582("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)Aether.LOGGER).error(arg_0)).ifPresent(propertiesTag -> tag.method_10566("Properties", propertiesTag));
    }

    private static class_3492 makeSettings(class_3485 structureTemplateManager, class_2487 tag, class_2960 location) {
        class_3499 structuretemplate = structureTemplateManager.method_15091(location);
        class_2338 blockpos = new class_2338(structuretemplate.method_15160().method_10263() / 2, 0, structuretemplate.method_15160().method_10260() / 2);
        return GlowstoneRuinedPortalPiece.makeSettings(class_2415.valueOf((String)tag.method_10558("Mirror")), class_2470.valueOf((String)tag.method_10558("Rotation")), blockpos, (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Properties"))).getOrThrow(true, arg_0 -> ((Logger)Aether.LOGGER).error(arg_0)));
    }

    private static class_3492 makeSettings(class_2415 mirror, class_2470 rotation, class_2338 pos, Properties properties) {
        class_3793 blockIgnoreProcessor = properties.airPocket ? class_3793.field_16718 : class_3793.field_16721;
        class_3492 structurePlaceSettings = new class_3492().method_15123(rotation).method_15125(mirror).method_15119(pos).method_16184((class_3491)blockIgnoreProcessor).method_16184((class_3491)new SurfaceRuleProcessor()).method_16184((class_3491)new GlowstonePortalAgeProcessor(properties.mossiness)).method_16184((class_3491)new DoubleDropsProcessor()).method_16184((class_3491)new class_6378(class_3481.field_33757));
        if (properties.replaceWithHolystone) {
            structurePlaceSettings.method_16184((class_3491)HolystoneReplaceProcessor.INSTANCE);
        }
        return structurePlaceSettings;
    }

    public void method_14931(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 pos) {
        class_3341 boundingbox = this.field_15433.method_16187(this.field_15434, this.field_15432);
        if (box.method_14662((class_2382)boundingbox.method_22874())) {
            box.method_35412(boundingbox);
            super.method_14931(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadAetherGrass(random, (class_1936)level);
            this.addDirtBuryingBelowPortal(random, (class_1936)level);
            if (this.properties.vines || this.properties.overgrown) {
                class_2338.method_23627((class_3341)this.method_14935()).forEach(p_229127_ -> {
                    if (this.properties.vines) {
                        this.maybeAddVines(random, (class_1936)level, (class_2338)p_229127_);
                    }
                    if (this.properties.overgrown) {
                        this.maybeAddLeavesAbove(random, (class_1936)level, (class_2338)p_229127_);
                    }
                });
            }
        }
    }

    protected void method_15026(String name, class_2338 pos, class_5425 level, class_5819 random, class_3341 box) {
    }

    private void maybeAddVines(class_5819 random, class_1936 level, class_2338 pos) {
        class_2350 direction;
        class_2338 blockPos;
        class_2680 relativeState;
        class_2680 blockState = level.method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10597) && (relativeState = level.method_8320(blockPos = pos.method_10093(direction = GlowstoneRuinedPortalPiece.method_35457((class_5819)random)))).method_26215() && class_2248.method_9501((class_265)blockState.method_26220((class_1922)level, pos), (class_2350)direction)) {
            class_2746 property = class_2541.method_10828((class_2350)direction.method_10153());
            level.method_8652(blockPos, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)property, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void maybeAddLeavesAbove(class_5819 random, class_1936 level, class_2338 pos) {
        if (random.method_43057() < 0.5f && level.method_8320(pos).method_27852((class_2248)AetherBlocks.AETHER_GRASS_BLOCK.get()) && level.method_8320(pos.method_10084()).method_26215()) {
            level.method_8652(pos.method_10084(), (class_2680)class_2246.field_10335.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void addDirtBuryingBelowPortal(class_5819 random, class_1936 level) {
        for (int i = this.field_15315.method_35415() + 1; i < this.field_15315.method_35418(); ++i) {
            for (int j = this.field_15315.method_35417() + 1; j < this.field_15315.method_35420(); ++j) {
                class_2338 blockPos = new class_2338(i, this.field_15315.method_35416(), j);
                if (!level.method_8320(blockPos).method_27852((class_2248)AetherBlocks.AETHER_GRASS_BLOCK.get())) continue;
                this.addDirtBuryingColumn(random, level, blockPos.method_10074());
            }
        }
    }

    private void addDirtBuryingColumn(class_5819 random, class_1936 level, class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        this.placeAetherDirtOrGrass(random, level, (class_2338)mutableBlockPos);
        for (int i = 8; i > 0 && random.method_43057() < 0.5f; --i) {
            mutableBlockPos.method_10098(class_2350.field_11033);
            this.placeAetherDirtOrGrass(random, level, (class_2338)mutableBlockPos);
        }
    }

    private void spreadAetherGrass(class_5819 random, class_1936 level) {
        boolean flag = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        class_2338 blockPos = this.field_15315.method_22874();
        int i = blockPos.method_10263();
        int j = blockPos.method_10260();
        float[] afloat = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = afloat.length;
        int l = (this.field_15315.method_35414() + this.field_15315.method_14663()) / 2;
        int i1 = random.method_43048(Math.max(1, 8 - l / 2));
        class_2338.class_2339 mutablePos = class_2338.field_10980.method_25503();
        for (int k1 = i - k; k1 <= i + k; ++k1) {
            for (int l1 = j - k; l1 <= j + k; ++l1) {
                int i2 = Math.abs(k1 - i) + Math.abs(l1 - j);
                int j2 = Math.max(0, i2 + i1);
                if (j2 >= k) continue;
                float f = afloat[j2];
                if (!(random.method_43058() < (double)f)) continue;
                int k2 = GlowstoneRuinedPortalPiece.getSurfaceY(level, k1, l1, this.verticalPlacement);
                int l2 = flag ? k2 : Math.min(this.field_15315.method_35416(), k2);
                mutablePos.method_10103(k1, l2, l1);
                if (Math.abs(l2 - this.field_15315.method_35416()) > 3 || !this.canBlockBeReplacedByAetherGrass(level, (class_2338)mutablePos)) continue;
                this.placeAetherDirtOrGrass(random, level, (class_2338)mutablePos);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(random, level, (class_2338)mutablePos);
                }
                this.addDirtBuryingColumn(random, level, mutablePos.method_10074());
            }
        }
    }

    private boolean canBlockBeReplacedByAetherGrass(class_1936 level, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos);
        return blockstate.method_26164(AetherTags.Blocks.RUINED_PORTAL_GROUND_REPLACEABLE);
    }

    private void placeAetherDirtOrGrass(class_5819 random, class_1936 level, class_2338 pos) {
        class_2680 grass = GlowstoneRuinedPortalPiece.getSurfaceBlockForPlacement(level, pos, level.method_8320(pos));
        if (SpreadingSnowyDirtBlockAccessor.callCanBeGrass(grass, (class_4538)level, pos)) {
            level.method_8652(pos, grass, 3);
            this.growGrassAndFlowers(random, level, pos.method_10084());
        } else {
            level.method_8652(pos, (class_2680)((class_2248)AetherBlocks.AETHER_DIRT.get()).method_9564().method_11657((class_2769)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void growGrassAndFlowers(class_5819 random, class_1936 level, class_2338 pos) {
        int featureType = random.method_43048(50);
        if (random.method_43048(100) < 20 && level.method_22347(pos)) {
            if (featureType < 5 && level.method_8320(pos.method_10074()).method_26164(AetherTags.Blocks.AETHER_DIRT)) {
                class_2248 flower = random.method_43056() ? (class_2248)AetherBlocks.PURPLE_FLOWER.get() : (class_2248)AetherBlocks.WHITE_FLOWER.get();
                level.method_8652(pos, flower.method_9564(), 2);
            } else if (random.method_43048(50) > 5) {
                level.method_8652(pos, class_2246.field_10479.method_9564(), 2);
            } else {
                class_2320.method_10021((class_1936)level, (class_2680)class_2246.field_10214.method_9564(), (class_2338)pos, (int)2);
            }
        }
    }

    private static int getSurfaceY(class_1936 level, int x, int z, VerticalPlacement verticalPlacement) {
        return level.method_8624(GlowstoneRuinedPortalPiece.getHeightMapType(verticalPlacement), x, z) - 1;
    }

    public static class_2902.class_2903 getHeightMapType(VerticalPlacement verticalPlacement) {
        return verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR ? class_2902.class_2903.field_13200 : class_2902.class_2903.field_13202;
    }

    public static class_2680 getSurfaceBlockForPlacement(class_1936 level, class_2338 pos, class_2680 originalState) {
        class_3215 serverChunkCache;
        class_2794 class_27942;
        class_2802 class_28022;
        class_3233 region;
        class_5281 worldGenLevel;
        if (level instanceof class_5281 && (!((worldGenLevel = (class_5281)level) instanceof class_3233) || !BlockLogicUtil.isOutOfBounds(pos, (region = (class_3233)worldGenLevel).method_33561())) && worldGenLevel.method_23753(pos).method_40220(AetherTags.Biomes.HAS_RUINED_PORTAL_AETHER) && (class_28022 = worldGenLevel.method_8398()) instanceof class_3215 && (class_27942 = (serverChunkCache = (class_3215)class_28022).method_12129()) instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)class_27942;
            class_5284 settingsHolder = (class_5284)noiseBasedChunkGenerator.method_41541().comp_349();
            class_6686.class_6708 surfaceRule = settingsHolder.comp_478();
            class_2791 chunkAccess = worldGenLevel.method_22350(pos);
            class_6568 noisechunk = ((ChunkAccessAccessor)chunkAccess).aether$getNoiseChunk();
            if (noisechunk != null) {
                class_5873 carvingcontext = new class_5873(noiseBasedChunkGenerator, worldGenLevel.method_30349(), chunkAccess.method_39460(), noisechunk, serverChunkCache.method_41248(), surfaceRule);
                Optional state = carvingcontext.method_39114(arg_0 -> ((class_4543)worldGenLevel.method_22385()).method_22393(arg_0), chunkAccess, pos, false);
                if (state.isPresent() && originalState.method_26164(AetherTags.Blocks.AETHER_DIRT) && !originalState.method_27852((class_2248)AetherBlocks.AETHER_DIRT.get()) && ((class_2680)state.get()).method_26164(AetherTags.Blocks.AETHER_DIRT)) {
                    return (class_2680)state.get();
                }
            }
        }
        return (class_2680)((class_2248)AetherBlocks.AETHER_GRASS_BLOCK.get()).method_9564().method_11657((class_2769)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true));
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(properties -> properties.replaceWithHolystone)).apply((Applicative)codec, Properties::new));
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithHolystone;

        public Properties() {
        }

        public Properties(float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithHolystone) {
            this.mossiness = mossiness;
            this.airPocket = airPocket;
            this.overgrown = overgrown;
            this.vines = vines;
            this.replaceWithHolystone = replaceWithHolystone;
        }
    }

    public static enum VerticalPlacement implements class_3542
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor");

        public static final class_3542.class_7292<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String name) {
            return (VerticalPlacement)CODEC.method_42633(name);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(VerticalPlacement::values);
        }
    }
}

