/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_6626;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import org.apache.commons.lang3.mutable.MutableInt;

public class BronzeDungeonStructure
extends class_3195 {
    public static final Codec<BronzeDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BronzeDungeonStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("maxrooms").forGetter(o -> o.maxRooms), (App)Codec.INT.fieldOf("aboveBottom").forGetter(o -> o.aboveBottom), (App)Codec.INT.fieldOf("belowTop").forGetter(o -> o.belowTop)).apply((Applicative)builder, BronzeDungeonStructure::new));
    private final int maxRooms;
    private final int aboveBottom;
    private final int belowTop;

    public BronzeDungeonStructure(class_3195.class_7302 settings, int maxRooms, int aboveBottom, int belowTop) {
        super(settings);
        this.maxRooms = maxRooms;
        this.aboveBottom = aboveBottom;
        this.belowTop = belowTop;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_3485 templateManager;
        class_7138 randomState;
        class_5539 heightAccessor;
        class_1923 chunkPos = context.comp_568();
        class_2794 chunkGenerator = context.comp_562();
        int height = BronzeDungeonStructure.findStartingHeight(chunkGenerator, heightAccessor = context.comp_569(), chunkPos, randomState = context.comp_564(), templateManager = context.comp_565(), this.aboveBottom, this.belowTop);
        if (height <= heightAccessor.method_31607()) {
            MutableInt y = new MutableInt(height);
            chunkPos = BronzeDungeonStructure.searchNearbyChunks(chunkPos, y, chunkGenerator, heightAccessor, randomState, templateManager, this.aboveBottom, this.belowTop);
            height = y.getValue();
            if (height <= heightAccessor.method_31607()) {
                return Optional.empty();
            }
        }
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), height, chunkPos.method_8328());
        return Optional.of(new class_3195.class_7150(blockPos, builder -> this.generatePieces((class_6626)builder, context, blockPos)));
    }

    private void generatePieces(class_6626 builder, class_3195.class_7149 context, class_2338 startPos) {
        BronzeDungeonBuilder graph = new BronzeDungeonBuilder(context, this.maxRooms);
        graph.initializeDungeon(startPos, context, builder);
    }

    private static class_1923 searchNearbyChunks(class_1923 chunkPos, MutableInt height, class_2794 generator, class_5539 heightAccessor, class_7138 randomState, class_3485 templateManager, int aboveBottom, int belowTop) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_1923 offset;
                int y;
                if (x == 0 && z == 0 || (y = BronzeDungeonStructure.findStartingHeight(generator, heightAccessor, offset = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z), randomState, templateManager, aboveBottom, belowTop)) <= heightAccessor.method_31607()) continue;
                height.setValue(y);
                return offset;
            }
        }
        return chunkPos;
    }

    private static int findStartingHeight(class_2794 generator, class_5539 heightAccessor, class_1923 chunkPos, class_7138 random, class_3485 templateManager, int aboveBottom, int belowTop) {
        int minX = chunkPos.method_8326() - 1;
        int minZ = chunkPos.method_8328() - 1;
        int maxX = chunkPos.method_8327() + 1;
        int maxZ = chunkPos.method_8329() + 1;
        class_4966[] columns = new class_4966[]{generator.method_26261(minX, minZ, heightAccessor, random), generator.method_26261(minX, maxZ, heightAccessor, random), generator.method_26261(maxX, minZ, heightAccessor, random), generator.method_26261(maxX, maxZ, heightAccessor, random)};
        int roomHeight = BronzeDungeonStructure.checkRoomHeight(templateManager, new class_2960("aether", "bronze_dungeon/boss_room"));
        int height = heightAccessor.method_31607();
        int maxHeight = heightAccessor.method_31600() - belowTop;
        int thickness = roomHeight + 2;
        int currentThickness = 0;
        for (int y = height + aboveBottom; y <= maxHeight; ++y) {
            if (BronzeDungeonStructure.checkEachCornerAtY(columns, y)) {
                ++currentThickness;
                continue;
            }
            if (currentThickness > thickness) {
                thickness = currentThickness;
                height = y;
            }
            currentThickness = 0;
        }
        int offset = (thickness + roomHeight) / 2;
        return height -= offset;
    }

    private static int checkRoomHeight(class_3485 manager, class_2960 roomName) {
        class_3499 template = manager.method_15091(roomName);
        return template.method_15160().method_10264();
    }

    private static boolean checkEachCornerAtY(class_4966[] columns, int y) {
        for (class_4966 column : columns) {
            if (!column.method_32892(y).method_26215() && !column.method_32892(y).method_26164(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) continue;
            return false;
        }
        return true;
    }

    public class_3341 method_41609(class_3341 box) {
        return box;
    }

    public class_7151<?> method_41618() {
        return (class_7151)AetherStructureTypes.BRONZE_DUNGEON.get();
    }
}

