/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.builder;

import com.aetherteam.aether.recipe.AetherBookCategory;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AetherCookingRecipeBuilder
implements class_5797 {
    private final class_7800 category;
    private final AetherBookCategory bookCategory;
    private final class_1792 result;
    private final class_1856 ingredient;
    private final float experience;
    private final int cookingTime;
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    @Nullable
    private String group;
    private final class_1865<? extends class_1874> serializer;

    public AetherCookingRecipeBuilder(class_7800 category, AetherBookCategory bookCategory, class_1935 result, class_1856 ingredient, float experience, int cookingTime, class_1865<? extends class_1874> serializer) {
        this.category = category;
        this.bookCategory = bookCategory;
        this.result = result.method_8389();
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.serializer = serializer;
    }

    public static AetherCookingRecipeBuilder generic(class_1856 ingredient, class_7800 category, class_1935 result, float experience, int cookingTime, class_1865<? extends class_1874> serializer) {
        return new AetherCookingRecipeBuilder(category, AetherCookingRecipeBuilder.determineRecipeCategory(serializer, category), result, ingredient, experience, cookingTime, serializer);
    }

    public AetherCookingRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public AetherCookingRecipeBuilder unlockedBy(String criterionName, class_184 criterionTrigger) {
        this.advancement.method_709(criterionName, criterionTrigger);
        return this;
    }

    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 id) {
        this.ensureValid(id);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
        finishedRecipeConsumer.accept(new Result(id, this.group == null ? "" : this.group, this.bookCategory, this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, id.method_45138("recipes/" + this.category.method_46203() + "/"), this.serializer));
    }

    private static AetherBookCategory determineRecipeCategory(class_1865<? extends class_1874> serializer, class_7800 category) {
        if (serializer == AetherRecipeSerializers.ENCHANTING.get()) {
            return switch (category) {
                case class_7800.field_40634, class_7800.field_40635 -> AetherBookCategory.ENCHANTING_BLOCKS;
                case class_7800.field_40640 -> AetherBookCategory.ENCHANTING_FOOD;
                default -> AetherBookCategory.ENCHANTING_MISC;
            };
        }
        if (serializer == AetherRecipeSerializers.REPAIRING.get()) {
            return AetherBookCategory.ENCHANTING_REPAIR;
        }
        if (serializer == AetherRecipeSerializers.FREEZING.get()) {
            return switch (category) {
                case class_7800.field_40634, class_7800.field_40635 -> AetherBookCategory.FREEZABLE_BLOCKS;
                default -> AetherBookCategory.FREEZABLE_MISC;
            };
        }
        throw new IllegalStateException("Unknown cooking recipe type; may not belong to the Aether");
    }

    private void ensureValid(class_2960 id) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }

    static class Result
    implements class_2444 {
        private final class_2960 id;
        private final String group;
        private final AetherBookCategory category;
        private final class_1856 ingredient;
        private final class_1792 result;
        private final float experience;
        private final int cookingTime;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final class_1865<? extends class_1874> serializer;

        public Result(class_2960 id, String group, AetherBookCategory category, class_1856 ingredient, class_1792 result, float experience, int cookingTime, class_161.class_162 advancement, class_2960 advancementId, class_1865<? extends class_1874> serializer) {
            this.id = id;
            this.group = group;
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = serializer;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("category", this.category.method_15434());
            json.add("ingredient", this.ingredient.method_8089());
            class_2960 itemLocation = class_7923.field_41178.method_10221((Object)this.result);
            if (itemLocation == null) {
                throw new IllegalStateException("Item: " + String.valueOf(this.result) + " does not exist");
            }
            json.addProperty("result", itemLocation.toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public class_1865<?> method_17800() {
            return this.serializer;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

