/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk.data;

import com.aetherteam.aether.perk.types.DeveloperGlow;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;

public class PerkSavedData
extends class_18 {
    public static final String FILE_NAME = "perks";
    private final Map<UUID, MoaData> storedSkinData = new HashMap<UUID, MoaData>();
    private final Map<UUID, Halo> storedHaloData = new HashMap<UUID, Halo>();
    private final Map<UUID, DeveloperGlow> storedDeveloperGlowData = new HashMap<UUID, DeveloperGlow>();

    public class_2487 method_75(class_2487 tag) {
        class_2487 storedSkinDataTag = new class_2487();
        for (Map.Entry<UUID, MoaData> entry : this.storedSkinData.entrySet()) {
            class_2487 class_24872 = new class_2487();
            if (entry.getValue().moaUUID() != null) {
                class_24872.method_25927("MoaUUID", entry.getValue().moaUUID());
            }
            if (entry.getValue().moaSkin() != null) {
                class_24872.method_10582("MoaSkin", entry.getValue().moaSkin().getId());
            }
            storedSkinDataTag.method_10566(entry.getKey().toString(), (class_2520)class_24872);
        }
        tag.method_10566("StoredSkinData", (class_2520)storedSkinDataTag);
        class_2487 storedHaloDataTag = new class_2487();
        for (Map.Entry<UUID, Halo> entry : this.storedHaloData.entrySet()) {
            class_2487 haloEntryTag = new class_2487();
            if (entry.getValue().hexColor() != null) {
                haloEntryTag.method_10582("HexColor", entry.getValue().hexColor());
            }
            storedHaloDataTag.method_10566(entry.getKey().toString(), (class_2520)haloEntryTag);
        }
        tag.method_10566("StoredHaloData", (class_2520)storedHaloDataTag);
        class_2487 class_24873 = new class_2487();
        for (Map.Entry<UUID, DeveloperGlow> developerGlowEntry : this.storedDeveloperGlowData.entrySet()) {
            class_2487 developerGlowTag = new class_2487();
            if (developerGlowEntry.getValue().hexColor() != null) {
                developerGlowTag.method_10582("HexColor", developerGlowEntry.getValue().hexColor());
            }
            class_24873.method_10566(developerGlowEntry.getKey().toString(), (class_2520)developerGlowTag);
        }
        tag.method_10566("StoredDeveloperGlowData", (class_2520)class_24873);
        return tag;
    }

    public static PerkSavedData load(class_2487 tag) {
        PerkSavedData data = PerkSavedData.create();
        for (String key : tag.method_10541()) {
            String hexColor;
            UUID playerUUID;
            if (key.equals("StoredSkinData")) {
                class_2487 storedSkinDataTag = tag.method_10562(key);
                for (String storedSkinDataKey : storedSkinDataTag.method_10541()) {
                    class_2487 moaDataEntryTag = storedSkinDataTag.method_10562(storedSkinDataKey);
                    playerUUID = UUID.fromString(storedSkinDataKey);
                    UUID moaUUID = null;
                    String moaSkinId = null;
                    if (moaDataEntryTag.method_10545("MoaUUID")) {
                        moaUUID = moaDataEntryTag.method_25926("MoaUUID");
                    }
                    if (moaDataEntryTag.method_10545("MoaSkin")) {
                        moaSkinId = moaDataEntryTag.method_10558("MoaSkin");
                    }
                    MoaSkins.MoaSkin moaSkin = MoaSkins.getMoaSkins().get(moaSkinId);
                    data.storedSkinData.put(playerUUID, new MoaData(moaUUID, moaSkin));
                }
            }
            if (key.equals("StoredHaloData")) {
                class_2487 storedHaloDataTag = tag.method_10562(key);
                for (String storedHaloDataKey : storedHaloDataTag.method_10541()) {
                    class_2487 haloEntryTag = storedHaloDataTag.method_10562(storedHaloDataKey);
                    playerUUID = UUID.fromString(storedHaloDataKey);
                    hexColor = null;
                    if (haloEntryTag.method_10545("HexColor")) {
                        hexColor = haloEntryTag.method_10558("HexColor");
                    }
                    data.storedHaloData.put(playerUUID, new Halo(hexColor));
                }
            }
            if (!key.equals("StoredDeveloperGlowData")) continue;
            class_2487 storedDeveloperGlowDataTag = tag.method_10562(key);
            for (String storedDeveloperGlowDataKey : storedDeveloperGlowDataTag.method_10541()) {
                class_2487 developerGlowEntryTag = storedDeveloperGlowDataTag.method_10562(storedDeveloperGlowDataKey);
                playerUUID = UUID.fromString(storedDeveloperGlowDataKey);
                hexColor = null;
                if (developerGlowEntryTag.method_10545("HexColor")) {
                    hexColor = developerGlowEntryTag.method_10558("HexColor");
                }
                data.storedDeveloperGlowData.put(playerUUID, new DeveloperGlow(hexColor));
            }
        }
        return data;
    }

    public static PerkSavedData create() {
        return new PerkSavedData();
    }

    public static PerkSavedData compute(class_26 dataStorage) {
        return (PerkSavedData)dataStorage.method_17924(PerkSavedData::load, PerkSavedData::create, FILE_NAME);
    }

    Map<UUID, MoaData> getStoredSkinData() {
        return ImmutableMap.copyOf(this.storedSkinData);
    }

    void modifyStoredSkinData(UUID uuid, MoaData moaData) {
        this.storedSkinData.put(uuid, moaData);
        this.method_80();
    }

    void removeStoredSkinData(UUID uuid) {
        this.storedSkinData.remove(uuid);
        this.method_80();
    }

    Map<UUID, Halo> getStoredHaloData() {
        return ImmutableMap.copyOf(this.storedHaloData);
    }

    void modifyStoredHaloData(UUID uuid, Halo halo) {
        this.storedHaloData.put(uuid, halo);
        this.method_80();
    }

    void removeStoredHaloData(UUID uuid) {
        this.storedHaloData.remove(uuid);
        this.method_80();
    }

    Map<UUID, DeveloperGlow> getStoredDeveloperGlowData() {
        return ImmutableMap.copyOf(this.storedDeveloperGlowData);
    }

    void modifyStoredDeveloperGlowData(UUID uuid, DeveloperGlow developerGlow) {
        this.storedDeveloperGlowData.put(uuid, developerGlow);
        this.method_80();
    }

    void removeStoredDeveloperGlowData(UUID uuid) {
        this.storedDeveloperGlowData.remove(uuid);
        this.method_80();
    }
}

