/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.player.AttackEntityEvent;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ToolAbilityListener {
    public static class_1268 INTERACTION_HAND;

    public static void setupToolModifications(BlockEvents.BlockToolModificationEvent event) {
        ToolAction toolAction;
        class_2680 oldState;
        class_2338 pos;
        class_1936 levelAccessor = event.getLevel();
        class_2680 newState = AbilityHooks.ToolHooks.setupToolActions(levelAccessor, pos = event.getPos(), oldState = event.getState(), toolAction = event.getToolAction());
        if (newState != oldState && !event.isSimulated() && !event.isCanceled()) {
            event.setFinalState(newState);
        }
    }

    public static void doHolystoneAbility(BlockEvents.BreakEvent event) {
        class_1657 player = event.getPlayer();
        class_1937 level = player.method_37908();
        class_2338 blockPos = event.getPos();
        class_1799 itemStack = player.method_6047();
        class_2680 blockState = event.getState();
        if (!event.isCanceled()) {
            AbilityHooks.ToolHooks.handleHolystoneToolAbility(player, level, blockPos, itemStack, blockState);
        }
    }

    public static void modifyBreakSpeed(PlayerEvents.BreakSpeed event) {
        class_2680 blockState = event.getState();
        class_1657 player = event.getEntity();
        class_1799 itemStack = player.method_6047();
        if (!event.isCanceled()) {
            event.setNewSpeed(AbilityHooks.ToolHooks.handleZaniteToolAbility(itemStack, event.getNewSpeed()));
            event.setNewSpeed(AbilityHooks.ToolHooks.reduceToolEffectiveness(player, blockState, itemStack, event.getNewSpeed()));
        }
    }

    public static void doGoldenOakStripping(BlockEvents.BlockToolModificationEvent event) {
        class_1936 levelAccessor = event.getLevel();
        class_2680 oldState = event.getState();
        class_1799 itemStack = event.getHeldItemStack();
        ToolAction toolAction = event.getToolAction();
        class_1838 context = event.getContext();
        if (!event.isSimulated() && !event.isCanceled()) {
            AbilityHooks.ToolHooks.stripGoldenOak(levelAccessor, oldState, itemStack, toolAction, context);
        }
    }

    public static void onEntityAttack(AttackEntityEvent event) {
        ToolAbilityListener.checkEntityTooFar((PlayerEvents)event, event.getTarget(), event.getEntity(), class_1268.field_5808);
    }

    private static void checkEntityTooFar(PlayerEvents event, class_1297 target, class_1657 player, class_1268 hand) {
        if (!event.isCanceled() && AbilityHooks.ToolHooks.entityTooFar(target, player, hand)) {
            event.setCanceled(true);
        }
    }

    private static void checkBlockTooFar(PlayerEvents event, class_1657 player, class_1268 hand) {
        if (!event.isCanceled() && AbilityHooks.ToolHooks.blockTooFar(player, hand)) {
            event.setCanceled(true);
        }
    }

    public static void init() {
        BlockEvents.BLOCK_MODIFICATION.register(ToolAbilityListener::setupToolModifications);
        PlayerEvents.BREAK_SPEED.register(ToolAbilityListener::modifyBreakSpeed);
        BlockEvents.BLOCK_BREAK.register(ToolAbilityListener::doHolystoneAbility);
        BlockEvents.BLOCK_MODIFICATION.register(ToolAbilityListener::doGoldenOakStripping);
        AttackEntityEvent.ATTACK_ENTITY.register(ToolAbilityListener::onEntityAttack);
    }
}

