/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.utils.FabricUtils;
import java.util.EnumSet;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1531;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class Swet
extends class_1621
implements MountableMob {
    private static final class_2940<Boolean> DATA_PLAYER_JUMPED_ID = class_2945.method_12791(Swet.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_MOUNT_JUMPING_ID = class_2945.method_12791(Swet.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_MID_JUMP_ID = class_2945.method_12791(Swet.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DATA_WATER_DAMAGE_SCALE_ID = class_2945.method_12791(Swet.class, (class_2941)class_2943.field_13320);
    private int ascendTimer;
    private boolean wasOnGround;
    private int jumpTimer;
    private float swetHeight = 1.0f;
    private float swetHeightO = 1.0f;
    private float swetWidth = 1.0f;
    private float swetWidthO = 1.0f;

    public Swet(class_1299<? extends Swet> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new SwetMoveControl(this);
        this.field_6194 = 5;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new ConsumeGoal(this));
        this.field_6201.method_6277(1, (class_1352)new HuntGoal(this));
        this.field_6201.method_6277(2, (class_1352)new SwetRandomDirectionGoal(this));
        this.field_6201.method_6277(4, (class_1352)new SwetKeepOnJumpingGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true, target -> !this.isFriendlyTowardEntity((class_1309)target) && !(target.method_5668() instanceof Swet)));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23717, 14.0).method_26868(class_5134.field_23718, 0.5);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_PLAYER_JUMPED_ID, (Object)false);
        this.method_5841().method_12784(DATA_MOUNT_JUMPING_ID, (Object)false);
        this.method_5841().method_12784(DATA_MID_JUMP_ID, (Object)false);
        this.method_5841().method_12784(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(class_2940<?> dataAccessor) {
        if (DATA_WATER_DAMAGE_SCALE_ID.equals(dataAccessor)) {
            this.method_18382();
        }
        super.method_5674(dataAccessor);
    }

    public static boolean checkSwetSpawnRules(class_1299<? extends Swet> swet, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(AetherTags.Blocks.SWET_SPAWNABLE_ON) && level.method_22335(pos, 0) > 8 && level.method_8407() != class_1267.field_5801 && (reason != class_3730.field_16459 || !Swet.inRadiusOfBanner(level, pos, 40) && !Swet.inRadiusOfSwetCape(level, pos, 40));
    }

    private static boolean inRadiusOfBanner(class_1936 level, class_2338 pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    class_2586 class_25862;
                    class_2338 offsetPos;
                    if (xOffset * xOffset + yOffset * yOffset + zOffset * zOffset > radius * radius || !level.method_8320(offsetPos = pos.method_10069(xOffset, yOffset, zOffset)).method_27852(class_2246.field_10062) || !((class_25862 = level.method_8321(offsetPos)) instanceof class_2573)) continue;
                    class_2573 bannerBlockEntity = (class_2573)class_25862;
                    if (!AetherBlocks.SWET_BANNER_PATTERN.method_16375().equals((Object)class_2573.method_24281((class_1799)bannerBlockEntity.method_10907()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean inRadiusOfSwetCape(class_1936 level, class_2338 pos, int radius) {
        return !level.method_18023(class_5575.method_31795(class_1531.class), class_238.method_30048((class_243)pos.method_46558(), (double)(radius * 2), (double)(radius * 2), (double)(radius * 2)), EquipmentUtil::hasSwetCape).isEmpty();
    }

    public void method_5773() {
        if (this.method_5799()) {
            this.spawnDissolveParticles();
            if (this.getWaterDamageScale() < 0.9f) {
                this.setWaterDamageScale(this.getWaterDamageScale() + 0.02f);
            }
        }
        if (this.getWaterDamageScale() >= 0.9f && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
        this.tick((class_1308)this);
        this.riderTick((class_1308)this);
        super.method_5773();
        if (!this.method_24828() && this.method_18798().method_10214() < 0.05 && this.ascendTimer > 0) {
            this.method_18800(this.method_18798().method_10216() * 1.2, 0.07, this.method_18798().method_10215() * 1.2);
            --this.ascendTimer;
        }
        if (this.method_24828()) {
            this.ascendTimer = 10;
        }
        if (!this.hasPrey() && this.canSpawnSplashParticles() && this.method_37908().method_8608()) {
            double d = (float)this.method_23317() + (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.3f;
            double d1 = (float)this.method_23318() + this.method_17682();
            double d2 = (float)this.method_23321() + (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.3f;
            this.method_37908().method_8406((class_2394)class_2398.field_11202, d, d1 - 0.25, d2, 0.0, 0.0, 0.0);
        }
        if (!this.method_5987()) {
            this.setMidJump(!this.method_24828());
            if (this.method_37908().method_8608()) {
                this.swetHeightO = this.swetHeight;
                this.swetWidthO = this.swetWidth;
                this.jumpTimer = this.getMidJump() ? ++this.jumpTimer : 0;
                if (this.getJumpTimer() > 1) {
                    this.swetHeight = 1.425f;
                    this.swetWidth = 0.875f;
                    float scale = Math.min(this.getJumpTimer(), 10);
                    if (this.getJumpTimer() > 2) {
                        this.swetHeight -= 0.04f * scale;
                        this.swetWidth += 0.04f * scale;
                    }
                    if (this.getJumpTimer() > 3) {
                        this.swetHeight -= 0.02f * scale;
                        this.swetWidth += 0.02f * scale;
                    }
                } else {
                    this.swetHeight = this.swetHeight < 1.0f ? this.swetHeight + 0.25f : 1.0f;
                    this.swetWidth = this.swetWidth > 1.0f ? this.swetWidth - 0.25f : 1.0f;
                }
            }
            this.wasOnGround = this.method_24828();
        }
        if (this.isFriendly()) {
            this.method_38785();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5968() != null && (this.hasPrey() || this.isFriendlyTowardEntity(this.method_5968()) || this.method_5968().method_5668() instanceof Swet)) {
            this.method_5980(null);
        }
    }

    public void method_6091(class_243 vector) {
        this.travel((class_1308)this, vector);
        if (this.method_5805()) {
            class_1309 entity = this.method_5642();
            if (this.method_5782() && entity != null) {
                if (this.method_24828() && !this.getPlayerJumped() && (this.method_18798().method_10216() != 0.0 || this.method_18798().method_10215() != 0.0)) {
                    this.method_18800(this.method_18798().method_10216(), 0.42f, this.method_18798().method_10215());
                }
                this.method_38785();
            }
        }
    }

    @Override
    public void travelWithInput(class_243 motion) {
        super.method_6091(motion);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608() && !this.hasPrey() && this.isFriendlyTowardEntity((class_1309)player) && this.method_17825() >= super.method_17825()) {
            this.consumePassenger((class_1309)player);
        }
        return class_1269.field_5811;
    }

    public void consumePassenger(class_1309 livingEntity) {
        this.method_5783((class_3414)AetherSoundEvents.ENTITY_SWET_ATTACK.get(), 0.5f, (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f + 1.0f);
        EntityUtil.copyRotations((class_1297)livingEntity, (class_1297)this);
        this.method_18799(livingEntity.method_18798());
        livingEntity.method_5873((class_1297)this, true);
    }

    public void spawnDissolveParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_8421((class_1297)this, (byte)70);
        }
    }

    public void method_5650(class_1297.class_5529 pReason) {
        this.method_31745(pReason);
    }

    public boolean getMidJump() {
        return (Boolean)this.method_5841().method_12789(DATA_MID_JUMP_ID);
    }

    public void setMidJump(boolean midJump) {
        this.method_5841().method_12778(DATA_MID_JUMP_ID, (Object)midJump);
    }

    public float getWaterDamageScale() {
        return ((Float)this.method_5841().method_12789(DATA_WATER_DAMAGE_SCALE_ID)).floatValue();
    }

    public void setWaterDamageScale(float scale) {
        this.method_5841().method_12778(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(scale));
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.method_5841().method_12789(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.method_5841().method_12778(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.method_5841().method_12789(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.method_5841().method_12778(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    public float getSwetHeight() {
        return this.swetHeight;
    }

    public float getSwetHeightO() {
        return this.swetHeightO;
    }

    public float getSwetWidth() {
        return this.swetWidth;
    }

    public float getSwetWidthO() {
        return this.swetWidthO;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)AetherSoundEvents.ENTITY_SWET_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)AetherSoundEvents.ENTITY_SWET_DEATH.get();
    }

    protected class_3414 method_7160() {
        return (class_3414)AetherSoundEvents.ENTITY_SWET_SQUISH.get();
    }

    public boolean hasPrey() {
        return this.method_31483() != null;
    }

    public boolean canSpawnSplashParticles() {
        return true;
    }

    public boolean isFriendly() {
        return this.method_5642() != null;
    }

    public boolean isFriendlyTowardEntity(class_1309 entity) {
        return EquipmentUtil.hasSwetCape(entity);
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public int method_7154() {
        return this.method_6051().method_43048(20) + 10;
    }

    public float method_6106() {
        class_1309 entity = this.method_5642();
        if (this.method_5782() && entity != null) {
            return 0.5f;
        }
        return 0.325f;
    }

    @Override
    public double getMountJumpStrength() {
        return 1.2;
    }

    @Override
    public double jumpFactor() {
        return this.method_23313();
    }

    @Override
    public boolean canJump() {
        return this.method_24828() && this.isFriendly();
    }

    @Override
    public float getSteeringSpeed() {
        return (float)(this.method_26825(class_5134.field_23719) * (double)0.21f);
    }

    public float method_49484() {
        return this.method_5642() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public double method_5621() {
        return 1.4;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 livingEntity;
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309 && this.isFriendlyTowardEntity(livingEntity = (class_1309)class_12972)) {
            return livingEntity;
        }
        return null;
    }

    public class_243 method_24829(class_1309 livingEntity) {
        if (this.isFriendlyTowardEntity(livingEntity)) {
            return super.method_24829(livingEntity);
        }
        return this.method_19538();
    }

    public int method_7152() {
        return this.method_5782() ? 2 : 1;
    }

    public void method_7161(int size, boolean resetHealth) {
    }

    public float method_17825() {
        return super.method_17825() - super.method_17825() * this.getWaterDamageScale();
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.method_5864().method_18386().method_18383(this.method_17825());
    }

    protected boolean method_7163() {
        return false;
    }

    protected boolean method_23734() {
        return true;
    }

    public boolean spawnCustomParticles() {
        return true;
    }

    public void method_5711(byte id) {
        if (id == 70) {
            for (int i = 0; i < 10; ++i) {
                double f = this.method_6051().method_43057() * ((float)Math.PI * 2);
                double f1 = this.method_6051().method_43057() * this.swetWidth + 0.25f;
                double f2 = (double)(this.method_6051().method_43057() * this.swetHeight) - this.method_6051().method_43059() * 0.02 * 10.0;
                double f3 = (double)class_3532.method_15374((float)((float)f)) * f1;
                double f4 = (double)class_3532.method_15362((float)((float)f)) * f1;
                this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + f3, this.method_23318() + f2, this.method_23321() + f4, f3 * 1.5 + this.method_18798().method_10216(), 4.0, f4 * 1.5 + this.method_18798().method_10215());
            }
        } else if (id == 71) {
            this.method_30634(this.method_23317(), this.method_23318(), this.method_23321());
        } else {
            super.method_5711(id);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("WaterDamageScale", this.getWaterDamageScale());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("WaterDamageScale")) {
            this.setWaterDamageScale(tag.method_10583("WaterDamageScale"));
        }
    }

    public static class SwetMoveControl
    extends class_1335 {
        private float yRot;
        private int jumpDelay;
        private final Swet swet;
        private boolean isAggressive;
        private boolean canJump;

        public SwetMoveControl(Swet swet) {
            super((class_1308)swet);
            this.swet = swet;
            this.yRot = 180.0f * swet.method_36454() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setWantedMovement(double speed) {
            this.field_6372 = speed;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void method_6240() {
            if (this.swet.isFriendly()) {
                return;
            }
            this.swet.method_36456(this.method_6238(this.swet.method_36454(), this.yRot, 90.0f));
            this.swet.method_5847(this.swet.method_36454());
            this.swet.method_5636(this.swet.method_36454());
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.swet.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.swet.method_24828()) {
                    this.swet.method_6125((float)(this.field_6372 * this.swet.method_26825(class_5134.field_23719)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.swet.method_7154();
                        if (this.isAggressive) {
                            this.jumpDelay /= 6;
                        }
                        this.swet.method_5993().method_6233();
                        this.swet.method_5783((class_3414)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.method_6051().method_43057() - this.swet.method_6051().method_43057()) * 0.2f + 1.0f) * 0.8f);
                    } else {
                        this.swet.field_6212 = 0.0f;
                        this.swet.field_6250 = 0.0f;
                        this.swet.method_6125(0.0f);
                    }
                } else {
                    this.swet.method_6125((float)(this.field_6372 * this.swet.method_26825(class_5134.field_23719)));
                }
            }
        }
    }

    public static class ConsumeGoal
    extends class_1352 {
        private final Swet swet;
        private int jumps = 0;
        private float chosenDegrees = 0.0f;

        public ConsumeGoal(Swet swet) {
            this.swet = swet;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 passenger;
            Object e;
            return this.swet.hasPrey() && (e = this.swet.method_5685().get(0)) instanceof class_1309 && !this.swet.isFriendlyTowardEntity(passenger = (class_1309)e);
        }

        public void method_6268() {
            if (this.jumps <= 3) {
                if (this.swet.method_24828()) {
                    this.swet.method_37908().method_8421((class_1297)this.swet, (byte)71);
                    this.swet.method_5783((class_3414)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.method_6051().method_43057() - this.swet.method_6051().method_43057()) * 0.2f + 1.0f) * 0.8f);
                    this.chosenDegrees = this.swet.method_6051().method_43048(360);
                    if (this.jumps == 0) {
                        this.swet.method_18799(this.swet.method_18798().method_1031(0.0, 0.65, 0.0));
                    } else if (this.jumps == 1) {
                        this.swet.method_18799(this.swet.method_18798().method_1031(0.0, 0.75, 0.0));
                    } else if (this.jumps == 2) {
                        this.swet.method_18799(this.swet.method_18798().method_1031(0.0, 1.55, 0.0));
                    } else {
                        ((class_1297)this.swet.method_5685().get(0)).method_5848();
                        this.swet.spawnDissolveParticles();
                        this.swet.method_31472();
                    }
                    if (!this.swet.getMidJump()) {
                        ++this.jumps;
                    }
                }
                if (!this.swet.wasOnGround && this.swet.getJumpTimer() < 6) {
                    if (this.jumps == 1) {
                        this.moveHorizontal(0.0f, 0.1f, this.chosenDegrees);
                    } else if (this.jumps == 2) {
                        this.moveHorizontal(0.0f, 0.15f, this.chosenDegrees);
                    } else if (this.jumps == 3) {
                        this.moveHorizontal(0.0f, 0.3f, this.chosenDegrees);
                    }
                }
            }
        }

        public void moveHorizontal(float strafe, float forward, float rotation) {
            float f = class_3532.method_27285((float)strafe) + class_3532.method_27285((float)forward);
            if ((f = class_3532.method_15355((float)f)) < 1.0f) {
                f = 1.0f;
            }
            float f1 = class_3532.method_15374((float)(rotation * ((float)Math.PI / 180)));
            float f2 = class_3532.method_15362((float)(rotation * ((float)Math.PI / 180)));
            this.swet.method_18800((strafe *= f) * f2 - (forward *= f) * f1, this.swet.method_18798().method_10214(), forward * f2 + strafe * f1);
            class_1335 class_13352 = this.swet.method_5962();
            if (class_13352 instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)class_13352;
                swetMoveControl.yRot = rotation % 360.0f;
            }
        }
    }

    public static class HuntGoal
    extends class_1352 {
        private final Swet swet;

        public HuntGoal(Swet swet) {
            this.swet = swet;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            block3: {
                block2: {
                    class_1309 target = this.swet.method_5968();
                    if (this.swet.hasPrey() || target == null || !target.method_5805() || this.swet.isFriendlyTowardEntity(target)) break block2;
                    if (!(target instanceof class_1657)) break block3;
                    class_1657 player = (class_1657)target;
                    if (!player.method_31549().field_7480) break block3;
                }
                return false;
            }
            return this.swet.method_5962() instanceof SwetMoveControl;
        }

        public boolean method_6266() {
            class_1309 target = this.swet.method_5968();
            if (this.swet.hasPrey() || target == null || !target.method_5805()) {
                return false;
            }
            if (target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                if (player.method_31549().field_7480) {
                    return false;
                }
            }
            return !this.swet.isFriendlyTowardEntity(target);
        }

        public void method_6268() {
            class_1335 class_13352 = this.swet.method_5962();
            if (class_13352 instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)class_13352;
                class_1309 target = this.swet.method_5968();
                if (target != null) {
                    this.swet.method_5951((class_1297)target, 10.0f, 10.0f);
                    swetMoveControl.setDirection(this.swet.method_36454(), true);
                    swetMoveControl.setWantedMovement(1.0);
                    if (this.swet.method_5829().method_994(target.method_5829())) {
                        this.swet.consumePassenger(target);
                    }
                }
            }
        }
    }

    public static class SwetRandomDirectionGoal
    extends class_1352 {
        private final Swet swet;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SwetRandomDirectionGoal(Swet swet) {
            this.swet = swet;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.swet.method_5968() == null && (this.swet.method_24828() || FabricUtils.isInFluidType((class_1297)this.swet) || this.swet.method_6059(class_1294.field_5902)) && this.swet.method_5962() instanceof SwetMoveControl;
        }

        public void method_6268() {
            SwetMoveControl moveHelperController = (SwetMoveControl)this.swet.method_5962();
            float rot = moveHelperController.yRot;
            class_243 offset = new class_243(-Math.sin(rot * ((float)Math.PI / 180)) * 2.0, 0.0, Math.cos(rot * ((float)Math.PI / 180)) * 2.0);
            class_2338 offsetPos = class_2338.method_49638((class_2374)this.swet.method_19538().method_1019(offset));
            if (this.swet.method_37908().method_8624(class_2902.class_2903.field_13202, offsetPos.method_10263(), offsetPos.method_10260()) < offsetPos.method_10264() - this.swet.method_5850()) {
                this.nextRandomizeTime = this.method_38847(40 + this.swet.method_6051().method_43048(60));
                this.chosenDegrees += 180.0f;
                moveHelperController.setCanJump(false);
            } else {
                if (--this.nextRandomizeTime <= 0) {
                    this.nextRandomizeTime = this.method_38847(40 + this.swet.method_6051().method_43048(60));
                    this.chosenDegrees = this.swet.method_6051().method_43048(360);
                }
                moveHelperController.setCanJump(true);
            }
            moveHelperController.setDirection(this.chosenDegrees, false);
        }
    }

    public static class SwetKeepOnJumpingGoal
    extends class_1352 {
        private final Swet swet;

        public SwetKeepOnJumpingGoal(Swet swetEntity) {
            this.swet = swetEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean method_6264() {
            if (this.swet.method_5765()) return false;
            class_1335 class_13352 = this.swet.method_5962();
            if (!(class_13352 instanceof SwetMoveControl)) return false;
            SwetMoveControl moveHelperController = (SwetMoveControl)class_13352;
            if (!moveHelperController.canJump) return false;
            return true;
        }

        public void method_6268() {
            class_1335 movecontrol = this.swet.method_5962();
            if (movecontrol instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)movecontrol;
                swetMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

