/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.model.ValkyrieWingsModel;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.utils.FabricUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_591;

public class PlayerWingsLayer<T extends class_1657, M extends class_591<T>>
extends class_3887<T, M> {
    private static final class_2960 VALKYRIE_TEXTURE = new class_2960("aether", "textures/entity/mobs/valkyrie/valkyrie.png");
    private final ValkyrieWingsModel<class_1657> wings;

    public PlayerWingsLayer(class_3883<T, M> entityRenderer, class_5599 modelSet) {
        super(entityRenderer);
        this.wings = new ValkyrieWingsModel(modelSet.method_32072(AetherModelLayers.VALKYRIE_ARMOR_WINGS));
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EquipmentUtil.hasFullValkyrieSet(entity)) {
            AetherPlayer.getOptional(entity).ifPresent(aetherPlayer -> {
                this.setupWingRotation(entity, class_3532.method_16439((float)partialTicks, (float)aetherPlayer.getWingRotationO(), (float)aetherPlayer.getWingRotation()));
                class_4588 consumer = buffer.getBuffer(class_1921.method_23578((class_2960)VALKYRIE_TEXTURE));
                this.wings.method_2828(poseStack, consumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
    }

    public void setupWingRotation(T entity, float sinage) {
        sinage = !(entity.method_24828() || FabricUtils.isInFluidType(entity) || entity.method_5854() == null || entity.method_5854().method_24828()) ? (sinage *= 1.5f) : (sinage *= 0.3f);
        this.wings.rightWing.field_3675 = 0.4f;
        this.wings.rightWing.field_3674 = 0.125f;
        this.wings.leftWing.field_3675 = -0.4f;
        this.wings.leftWing.field_3674 = -0.125f;
        if (entity.method_18276()) {
            this.wings.rightWing.field_3654 = 0.45f;
            this.wings.rightWing.field_3656 = 3.33f;
            this.wings.rightWing.field_3655 = 3.388f;
            this.wings.leftWing.field_3654 = 0.45f;
            this.wings.leftWing.field_3656 = 3.33f;
            this.wings.leftWing.field_3655 = 3.388f;
        } else {
            this.wings.rightWing.field_3654 = 0.0f;
            this.wings.leftWing.field_3654 = 0.0f;
        }
        this.wings.rightWing.field_3675 -= class_3532.method_15374((float)sinage) / 6.0f;
        this.wings.rightWing.field_3674 = this.wings.rightWing.field_3674 - class_3532.method_15362((float)sinage) / (entity.method_24828() || FabricUtils.isInFluidType(entity) ? 8.0f : 3.0f);
        this.wings.leftWing.field_3675 += class_3532.method_15374((float)sinage) / 6.0f;
        this.wings.leftWing.field_3674 = this.wings.leftWing.field_3674 + class_3532.method_15362((float)sinage) / (entity.method_24828() || FabricUtils.isInFluidType(entity) ? 8.0f : 3.0f);
    }
}

