/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.mixin.mixins.client.accessor.GuiAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.HeartTypeAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public class AetherOverlays {
    private static final class_2960 TEXTURE_INEBRIATION_VIGNETTE = new class_2960("aether", "textures/blur/inebriation_vignette.png");
    private static final class_2960 TEXTURE_REMEDY_VIGNETTE = new class_2960("aether", "textures/blur/remedy_vignette.png");
    private static final class_2960 TEXTURE_SHIELD_OF_REPULSION_VIGNETTE = new class_2960("aether", "textures/blur/shield_of_repulsion_vignette.png");
    private static final class_2960 TEXTURE_COOLDOWN_BAR = new class_2960("aether", "textures/gui/cooldown_bar.png");
    private static final class_2960 TEXTURE_JUMPS = new class_2960("aether", "textures/gui/jumps.png");
    private static final class_2960 TEXTURE_LIFE_SHARD_HEARTS = new class_2960("aether", "textures/gui/life_shard_hearts.png");

    public static void registerOverlays() {
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderAetherPortalOverlay(guiGraphics, minecraft, window, AetherPlayer.get((class_1657)player), partialTicks);
            }
        });
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderInebriationOverlay(guiGraphics, minecraft, window, AetherPlayer.get((class_1657)player));
            }
        });
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderRemedyOverlay(guiGraphics, minecraft, window, AetherPlayer.get((class_1657)player));
            }
        });
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderRepulsionOverlay(guiGraphics, minecraft, window, AetherPlayer.get((class_1657)player));
            }
        });
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderHammerCooldownOverlay(guiGraphics, minecraft, window, player);
            }
        });
        HudRenderCallback.EVENT.register((guiGraphics, partialTicks) -> {
            class_310 minecraft = class_310.method_1551();
            class_1041 window = minecraft.method_22683();
            class_746 player = minecraft.field_1724;
            if (player != null) {
                AetherOverlays.renderMoaJumps(guiGraphics, window, player);
            }
        });
    }

    private static void renderAetherPortalOverlay(class_332 guiGraphics, class_310 minecraft, class_1041 window, AetherPlayer handler, float partialTicks) {
        class_4587 poseStack = guiGraphics.method_51448();
        float timeInPortal = handler.getPrevPortalAnimTime() + (handler.getPortalAnimTime() - handler.getPrevPortalAnimTime()) * partialTicks;
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            poseStack.method_22903();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            class_1058 textureAtlasSprite = minecraft.method_1541().method_3351().method_3339(((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).method_9564());
            guiGraphics.method_48465(0, 0, -90, window.method_4486(), window.method_4502(), textureAtlasSprite, 1.0f, 1.0f, 1.0f, timeInPortal);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            poseStack.method_22909();
        }
    }

    private static void renderInebriationOverlay(class_332 guiGraphics, class_310 minecraft, class_1041 window, AetherPlayer handler) {
        class_1657 player = handler.getPlayer();
        class_1293 inebriation = player.method_6112((class_1291)AetherEffects.INEBRIATION.get());
        double effectScale = (Double)minecraft.field_1690.method_42453().method_41753();
        if (inebriation != null) {
            float inebriationDuration = (float)(inebriation.method_5584() % 50) / 50.0f;
            float alpha = inebriationDuration * inebriationDuration / 5.0f + 0.4f;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_INEBRIATION_VIGNETTE);
        }
    }

    private static void renderRemedyOverlay(class_332 guiGraphics, class_310 minecraft, class_1041 window, AetherPlayer handler) {
        class_1657 player = handler.getPlayer();
        class_1293 remedy = player.method_6112((class_1291)AetherEffects.REMEDY.get());
        double effectScale = (Double)minecraft.field_1690.method_42453().method_41753();
        if (remedy != null) {
            int remedyStartDuration = handler.getRemedyStartDuration();
            int remedyDuration = remedy.method_5584();
            if (remedyStartDuration > 0 && remedyDuration > 0) {
                float alpha = (float)remedyDuration / (float)remedyStartDuration / 1.5f;
                AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_REMEDY_VIGNETTE);
            }
        }
    }

    private static void renderRepulsionOverlay(class_332 guiGraphics, class_310 minecraft, class_1041 window, AetherPlayer handler) {
        int projectileImpactedMaximum = handler.getProjectileImpactedMaximum();
        int projectileImpactedTimer = handler.getProjectileImpactedTimer();
        double effectScale = (Double)minecraft.field_1690.method_42453().method_41753();
        if (projectileImpactedTimer > 0) {
            float alpha = (float)projectileImpactedTimer / (float)projectileImpactedMaximum;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_SHIELD_OF_REPULSION_VIGNETTE);
        }
    }

    private static void renderVignette(class_332 guiGraphics, class_1041 window, double effectScale, float alpha, class_2960 resource) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        alpha = (float)((double)alpha * Math.sqrt(effectScale));
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
        guiGraphics.method_25291(resource, 0, 0, -90, 0.0f, 0.0f, window.method_4486(), window.method_4502(), window.method_4486(), window.method_4502());
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    private static void renderHammerCooldownOverlay(class_332 guiGraphics, class_310 minecraft, class_1041 window, class_746 player) {
        class_1661 inventory;
        if (((Boolean)AetherConfig.CLIENT.enable_hammer_cooldown_overlay.get()).booleanValue() && (inventory = player.method_31548()).method_43256(itemStack -> itemStack.method_31574((class_1792)AetherItems.HAMMER_OF_KINGBDOGZ.get()))) {
            for (class_1799 itemStack2 : inventory.field_7547) {
                float cooldownPercent;
                class_1792 item = itemStack2.method_7909();
                if (item != AetherItems.HAMMER_OF_KINGBDOGZ.get() || !((cooldownPercent = player.method_7357().method_7905(item, 0.0f)) > 0.0f)) continue;
                if (player.method_6047().method_7909() == item) {
                    itemStack2 = player.method_6047();
                } else if (player.method_6079().method_7909() == item) {
                    itemStack2 = player.method_6079();
                }
                String text = itemStack2.method_7964().getString().concat(" ").concat(class_2561.method_43471((String)"aether.hammer_of_kingbdogz_cooldown").getString());
                guiGraphics.method_25303(minecraft.field_1772, text, (int)((float)window.method_4486() / 2.0f - (float)minecraft.field_1772.method_1727(text) / 2.0f), 32, 0xFFFFFF);
                guiGraphics.method_25290(TEXTURE_COOLDOWN_BAR, window.method_4486() / 2 - 64, 42, 0.0f, 8.0f, 128, 8, 256, 256);
                guiGraphics.method_25290(TEXTURE_COOLDOWN_BAR, window.method_4486() / 2 - 64, 42, 0.0f, 0.0f, (int)(cooldownPercent * 128.0f), 8, 256, 256);
                break;
            }
        }
    }

    private static void renderMoaJumps(class_332 guiGraphics, class_1041 window, class_746 player) {
        class_1297 class_12972 = player.method_5854();
        if (class_12972 instanceof Moa) {
            Moa moa = (Moa)class_12972;
            for (int jumpCount = 0; jumpCount < moa.getMaxJumps(); ++jumpCount) {
                int xPos = window.method_4486() / 2 + jumpCount * 8 - moa.getMaxJumps() * 8 / 2;
                int yPos = 18;
                if (jumpCount < moa.getRemainingJumps()) {
                    guiGraphics.method_25290(TEXTURE_JUMPS, xPos, yPos, 0.0f, 0.0f, 9, 11, 256, 256);
                    continue;
                }
                guiGraphics.method_25290(TEXTURE_JUMPS, xPos, yPos, 10.0f, 0.0f, 9, 11, 256, 256);
            }
        }
    }

    public static void renderSilverLifeShardHearts(class_332 guiGraphics, class_310 minecraft, class_1041 window, class_329 gui, class_746 player) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        if (((Boolean)AetherConfig.CLIENT.enable_silver_hearts.get()).booleanValue() && minecraft.field_1761.method_2908()) {
            AetherPlayer.getOptional((class_1657)player).ifPresent(aetherPlayer -> {
                class_1324 attributeInstance;
                class_1657 innerPlayer = aetherPlayer.getPlayer();
                if (aetherPlayer.getLifeShardCount() > 0 && (attributeInstance = innerPlayer.method_5996(class_5134.field_23716)) != null) {
                    boolean highlight;
                    int lastLifeShardHealth = 0;
                    int lastOverallHealth = 0;
                    RenderSystem.enableBlend();
                    double overallHealth = attributeInstance.method_6194();
                    double maxLifeShardHealth = aetherPlayer.getLifeShardHealthAttributeModifier().method_6186();
                    int maxDefaultHealth = class_3532.method_15384((double)(overallHealth - maxLifeShardHealth));
                    int currentOverallHealth = class_3532.method_15386((float)innerPlayer.method_6032());
                    int currentLifeShardHealth = class_3532.method_15384((double)(maxDefaultHealth > 20 ? class_3532.method_15350((double)(currentOverallHealth - 20), (double)0.0, (double)maxLifeShardHealth) : (double)Math.min(player.method_6032(), (float)(currentOverallHealth - maxDefaultHealth))));
                    boolean bl = highlight = guiAccessor.aether$getHealthBlinkTime() > (long)gui.method_1738() && (guiAccessor.aether$getHealthBlinkTime() - (long)gui.method_1738()) / 3L % 2L == 1L;
                    if (class_156.method_658() - guiAccessor.aether$getLastHealthTime() > 1000L) {
                        lastOverallHealth = currentOverallHealth;
                        lastLifeShardHealth = currentLifeShardHealth;
                    }
                    guiAccessor.aether$getRandom().method_43052((long)(gui.method_1738() * 312871));
                    float displayOverallHealth = Math.max((float)overallHealth, (float)Math.max(lastOverallHealth, currentOverallHealth));
                    float displayLifeShardHealth = Math.max((float)maxLifeShardHealth, (float)Math.max(lastLifeShardHealth, currentLifeShardHealth));
                    int absorption = class_3532.method_15386((float)innerPlayer.method_6067());
                    int healthRows = class_3532.method_15386((float)((displayOverallHealth + (float)absorption) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    int left = window.method_4486() / 2 - 91;
                    int top = window.method_4502() - 39;
                    int regen = Integer.MIN_VALUE;
                    if (innerPlayer.method_6059(class_1294.field_5924)) {
                        regen = gui.method_1738() % class_3532.method_15386((float)(displayOverallHealth + 5.0f));
                    }
                    AetherOverlays.renderHearts(guiGraphics, innerPlayer, gui, left, top, regen, displayOverallHealth, displayLifeShardHealth, maxDefaultHealth, currentLifeShardHealth, rowHeight, absorption, highlight);
                    RenderSystem.disableBlend();
                }
            });
        }
    }

    private static void renderHearts(class_332 guiGraphics, class_1657 player, class_329 gui, int left, int top, int regen, float displayOverallHealth, float displayLifeShardHealth, int maxDefaultHealth, int lifeShardHealth, int rowHeight, int absorption, boolean highlight) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        class_329.class_6411 heartType = HeartTypeAccessor.callForPlayer(player);
        int overallHearts = class_3532.method_15384((double)((double)displayOverallHealth / 2.0));
        int lifeShardHearts = class_3532.method_15384((double)((double)displayLifeShardHealth / 2.0));
        int maxDefaultHearts = class_3532.method_15384((double)((double)maxDefaultHealth / 2.0));
        boolean tooManyHearts = overallHearts > 50;
        boolean tooLittleHearts = maxDefaultHearts < 10 && maxDefaultHearts > 0;
        for (int currentHeart = Math.min(overallHearts, lifeShardHearts - 1); currentHeart >= 0; --currentHeart) {
            boolean halfHeart;
            int x = left + (currentHeart + (tooLittleHearts ? overallHearts - lifeShardHearts : 0)) % 10 * 8;
            int y = top - (currentHeart + (tooManyHearts ? 0 : (maxDefaultHearts + currentHeart < 10 ? 0 : 10))) / 10 * rowHeight;
            if (class_3532.method_15386((float)player.method_6032()) + absorption <= 4) {
                y += guiAccessor.aether$getRandom().method_43048(2);
            }
            if (currentHeart + (maxDefaultHearts > 10 ? overallHearts - 10 : maxDefaultHearts) < overallHearts && currentHeart + Math.min(maxDefaultHearts, 10) - (tooManyHearts ? overallHearts : 0) == regen) {
                y -= 2;
            }
            int selectedContainer = currentHeart * 2;
            if (highlight && (float)selectedContainer < displayLifeShardHealth) {
                halfHeart = (float)(selectedContainer + 1) == displayLifeShardHealth;
                guiGraphics.method_25302(TEXTURE_LIFE_SHARD_HEARTS, x, y, heartType.method_37302(halfHeart, false), 0, 9, 9);
            }
            if (selectedContainer >= lifeShardHealth) continue;
            halfHeart = selectedContainer + 1 == lifeShardHealth;
            guiGraphics.method_25302(TEXTURE_LIFE_SHARD_HEARTS, x, y, heartType.method_37302(halfHeart, false), 0, 9, 9);
        }
    }
}

