/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.cumulus.client.CumulusClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5498;
import org.jetbrains.annotations.Nullable;

public class WorldDisplayHelper {
    public static boolean menuActive = false;
    @Nullable
    private static class_34 loadedSummary = null;

    public static void toggleWorldPreview() {
        if (((Boolean)AetherConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
            WorldDisplayHelper.enableWorldPreview();
        } else {
            WorldDisplayHelper.disableWorldPreview();
        }
    }

    public static void enableWorldPreview() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            WorldDisplayHelper.loadLevel();
        }
    }

    public static void loadLevel() {
        class_310 minecraft = class_310.method_1551();
        class_34 summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.method_1586().method_230(summary.method_248())) {
            WorldDisplayHelper.setActive();
            minecraft.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"selectWorld.data_read")));
            minecraft.method_41735().method_41894(minecraft.field_1755, summary.method_248());
        } else {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
        }
    }

    public static void enterLoadedLevel() {
        class_310 minecraft = class_310.method_1551();
        class_34 summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.method_1586().method_230(summary.method_248()) && minecraft.method_1576() != null) {
            WorldDisplayHelper.resetStates();
            minecraft.method_29970(null);
        }
    }

    public static void disableWorldPreview() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null) {
            WorldDisplayHelper.stopLevel((class_437)new class_424((class_2561)class_2561.method_43470((String)"")));
            WorldDisplayHelper.setMenu();
        }
    }

    public static void stopLevel(@Nullable class_437 screen) {
        WorldDisplayHelper.resetStates();
        class_310 minecraft = class_310.method_1551();
        class_1132 server = minecraft.method_1576();
        if (minecraft.field_1687 != null) {
            if (server != null) {
                server.method_3747(false);
            }
            if (screen != null) {
                minecraft.method_18096(screen);
            } else {
                minecraft.method_18099();
            }
        }
    }

    public static void setMenu() {
        CumulusClient.MENU_HELPER.setShouldFade(false);
        class_442 screen = CumulusClient.MENU_HELPER.applyMenu(CumulusClient.MENU_HELPER.getActiveMenu());
        if (screen != null) {
            class_310.method_1551().method_29970((class_437)screen);
        }
    }

    @Nullable
    public static class_34 getLevelSummary() {
        if (loadedSummary == null) {
            WorldDisplayHelper.findLevelSummary();
        }
        return loadedSummary;
    }

    public static void findLevelSummary() {
        class_310 minecraft = class_310.method_1551();
        class_32 source = minecraft.method_1586();
        try {
            ArrayList summaryList = new ArrayList((Collection)source.method_43417(source.method_235()).get());
            Collections.sort(summaryList);
            if (summaryList.size() > 0) {
                class_34 summary = null;
                for (int i = summaryList.size() - 1; i >= 0; --i) {
                    class_34 s = (class_34)summaryList.get(i);
                    if (s.method_27021() || s.method_33784()) continue;
                    class_32.class_5143 access = source.method_27002(s.method_248());
                    if (Files.exists(access.method_27424(AetherDimensions.AETHER_LEVEL), new LinkOption[0])) {
                        summary = s;
                    }
                    access.close();
                }
                if (summary != null) {
                    loadedSummary = summary;
                }
            }
        }
        catch (IOException | InterruptedException | UnsupportedOperationException | ExecutionException e) {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
            e.printStackTrace();
        }
    }

    public static boolean sameSummaries(class_34 summary) {
        return WorldDisplayHelper.getLevelSummary().method_248().equals(summary.method_248());
    }

    public static void resetStates() {
        WorldDisplayHelper.resetPlayerState();
        WorldDisplayHelper.resetActive();
    }

    public static void resetPlayerState() {
        class_310.method_1551().field_1690.field_1842 = false;
        class_310.method_1551().field_1690.method_31043(class_5498.field_26664);
    }

    public static void resetConfig() {
        AetherConfig.CLIENT.enable_world_preview.set((Object)false);
        AetherConfig.CLIENT.enable_world_preview.save();
    }

    public static void resetActive() {
        menuActive = false;
    }

    public static void setActive() {
        menuActive = true;
    }

    public static boolean isActive() {
        return menuActive;
    }

    public static void setupLevelForDisplay() {
        class_310 minecraft = class_310.method_1551();
        class_1132 server = minecraft.method_1576();
        if (server != null) {
            class_310.method_1551().field_1690.field_1842 = true;
            class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
            WorldDisplayHelper.setMenu();
        }
    }
}

