/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.AetherMenus;
import com.aetherteam.aether.client.AetherMenuUtil;
import com.aetherteam.aether.client.WorldDisplayHelper;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.sound.MusicSoundInstance;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.mixin.mixins.client.accessor.BossHealthOverlayAccessor;
import com.aetherteam.cumulus.api.Menu;
import com.aetherteam.cumulus.api.Menus;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_1143;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_445;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;

public class AetherMusicManager {
    private static final int FADE_LIMIT = 50;
    private static final class_5819 random = class_5819.method_43047();
    private static final class_310 minecraft = class_310.method_1551();
    private static final class_1142 musicManager = class_310.method_1551().method_1538();
    @Nullable
    private static class_1113 currentMusic;
    private static int nextSongDelay;
    private static Integer fade;

    public static void tick() {
        class_5195 music = AetherMusicManager.getSituationalMusic();
        Object object = currentMusic;
        if (object instanceof MusicSoundInstance) {
            MusicSoundInstance musicSoundInstance = (MusicSoundInstance)((Object)object);
            if (musicSoundInstance.isBossMusic()) {
                if (music == null || !AetherMusicManager.isAetherBossMusic(music)) {
                    if (fade == null) {
                        fade = 0;
                    }
                    musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                    object = fade;
                    fade = fade + 1;
                    if (fade >= 50) {
                        fade = null;
                        minecraft.method_1483().method_4870(currentMusic);
                        currentMusic = null;
                        nextSongDelay = Math.min(Integer.MAX_VALUE, class_3532.method_15395((class_5819)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get() / 2)));
                    }
                }
            } else if (music != null && AetherMusicManager.isAetherBossMusic(music)) {
                if (fade == null) {
                    fade = 0;
                }
                musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                object = fade;
                fade = fade + 1;
                if (fade >= 50) {
                    fade = null;
                    minecraft.method_1483().method_4870(currentMusic);
                    currentMusic = null;
                    nextSongDelay = 16;
                }
            }
        }
        if (music != null) {
            if (currentMusic != null && fade == null) {
                if (!((class_3414)music.method_27279().comp_349()).method_14833().equals((Object)currentMusic.method_4775()) && music.method_27282()) {
                    minecraft.method_1483().method_4870(currentMusic);
                    nextSongDelay = class_3532.method_15395((class_5819)random, (int)0, (int)(music.method_27280() / 2));
                }
                if (!minecraft.method_1483().method_4877(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, class_3532.method_15395((class_5819)random, (int)music.method_27280(), (int)music.method_27281()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.method_27281());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                AetherMusicManager.startPlaying(music);
            }
        } else if (currentMusic == null || !minecraft.method_1483().method_4877(currentMusic)) {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, class_3532.method_15395((class_5819)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get())));
            }
        }
    }

    public static void startPlaying(class_5195 music) {
        musicManager.method_4859();
        currentMusic = AetherMusicManager.isAetherBossMusic(music) ? MusicSoundInstance.forBossMusic((class_3414)music.method_27279().comp_349()) : MusicSoundInstance.forMusic((class_3414)music.method_27279().comp_349());
        if (currentMusic.method_4776() != class_1144.field_5592) {
            minecraft.method_1483().method_4873(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.method_1483().method_4870(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static class_1113 getCurrentMusic() {
        return currentMusic;
    }

    @Nullable
    public static <T extends class_1309> class_5195 getSituationalMusic() {
        if (!(AetherMusicManager.minecraft.field_1755 instanceof class_445)) {
            if (AetherMusicManager.isAetherWorldPreviewEnabled()) {
                return ((Menu)AetherMenus.THE_AETHER.get()).getMusic();
            }
            if (AetherMusicManager.isVanillaWorldPreviewEnabled()) {
                return ((Menu)Menus.MINECRAFT.get()).getMusic();
            }
            if (AetherMusicManager.minecraft.field_1724 != null) {
                if (AetherMusicManager.isAetherBossMusicActive()) {
                    class_5195 bossMusic;
                    T boss = AetherMusicManager.getBossFromFight();
                    if (boss != null && boss.method_6032() > 0.0f && (bossMusic = ((AetherBossMob)boss).getBossMusic()) != null) {
                        return ((AetherBossMob)boss).getBossMusic();
                    }
                } else {
                    class_6880 holder = AetherMusicManager.minecraft.field_1724.method_37908().method_23753(AetherMusicManager.minecraft.field_1724.method_24515());
                    if (AetherMusicManager.isCreative((class_6880<class_1959>)holder, (class_1657)AetherMusicManager.minecraft.field_1724)) {
                        return ((class_1959)holder.comp_349()).method_27343().orElse(class_1143.field_5586);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isAetherBossMusic(class_5195 music) {
        return music.method_27279().method_40220(AetherTags.SoundEvents.BOSS_MUSIC);
    }

    public static boolean isAetherBossMusicActive() {
        return (Boolean)AetherConfig.CLIENT.disable_aether_boss_music.get() == false && !AetherMusicManager.getAetherBossFights().isEmpty() && AetherMusicManager.minecraft.field_1705.method_1740().method_1798();
    }

    public static Map<UUID, class_345> getAetherBossFights() {
        return ((BossHealthOverlayAccessor)AetherMusicManager.minecraft.field_1705.method_1740()).getEvents().entrySet().stream().filter(entry -> GuiHooks.isAetherBossBar((UUID)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T extends class_1309> T getBossFromFight() {
        for (Map.Entry<UUID, class_345> event : AetherMusicManager.getAetherBossFights().entrySet()) {
            UUID eventUUID = event.getKey();
            int entityId = GuiHooks.BOSS_EVENTS.get(eventUUID);
            class_1297 entity = AetherMusicManager.minecraft.field_1724.method_37908().method_8469(entityId);
            if (!(entity instanceof class_1309) || !(entity instanceof AetherBossMob)) continue;
            return (T)((class_1309)entity);
        }
        return null;
    }

    public static boolean isAetherWorldPreviewEnabled() {
        return AetherMenuUtil.isAetherMenu() && AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_aether_world_preview_menu_music.get() == false;
    }

    public static boolean isVanillaWorldPreviewEnabled() {
        return AetherMenuUtil.isMinecraftMenu() && AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_vanilla_world_preview_menu_music.get() == false;
    }

    public static boolean isWorldPreviewEnabled() {
        return AetherMusicManager.minecraft.field_1724 != null && WorldDisplayHelper.isActive();
    }

    public static boolean isCreative(class_6880<class_1959> holder, class_1657 player) {
        return player.method_37908().method_27983() != class_1937.field_25181 && player.method_37908().method_27983() != class_1937.field_25180 && holder.method_40220(AetherTags.Biomes.AETHER_MUSIC) && !musicManager.method_4860(class_1143.field_5576) && (!player.method_5869() || !holder.method_40220(class_6908.field_37377)) && player.method_31549().field_7477 && player.method_31549().field_7478;
    }

    static {
        nextSongDelay = 100;
        fade = null;
    }
}

