/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.data.Constants;
import com.natamus.collective_common_forge.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundTag> blockEntities;
    private List<Pair<BlockPos, CompoundTag>> entities;
    private boolean parsedCorrectly = false;

    public Schematic(InputStream inputStream) {
        new Schematic(inputStream, null);
    }

    public Schematic(InputStream inputStream, Level level) {
        DefaultedRegistry blockRegistry = BuiltInRegistries.f_256975_;
        if (level != null) {
            blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        }
        String type = "";
        try {
            CompoundTag nbtdata = NbtIo.m_128939_((InputStream)inputStream);
            inputStream.close();
            if (nbtdata.m_128441_("Schematic")) {
                nbtdata = nbtdata.m_128469_("Schematic");
            }
            if (nbtdata.m_128441_("Length")) {
                this.width = nbtdata.m_128448_("Width");
                this.height = nbtdata.m_128448_("Height");
                this.length = nbtdata.m_128448_("Length");
            } else {
                ListTag sizeList = nbtdata.m_128437_("size", 3);
                this.width = (short)sizeList.m_128763_(0);
                this.height = (short)sizeList.m_128763_(1);
                this.length = (short)sizeList.m_128763_(2);
            }
            this.size = this.width * this.height * this.length;
            type = nbtdata.m_128441_("entities") ? "nbt" : (nbtdata.m_128441_("DataVersion") ? "schem" : "schematic");
            this.blockObjects = new SchematicBlockObject[this.size];
            this.entities = new ArrayList<Pair<BlockPos, CompoundTag>>();
            switch (type) {
                case "schem": {
                    ListTag tileentitynbtlist;
                    CompoundTag palette;
                    byte[] blockDataRaw;
                    int[] blockData = new int[this.width * this.height * this.length];
                    if (nbtdata.m_128451_("Version") == 2) {
                        blockDataRaw = nbtdata.m_128463_("BlockData");
                        palette = nbtdata.m_128469_("Palette");
                        tileentitynbtlist = nbtdata.m_128437_("BlockEntities", 10);
                        CompoundTag offsetCompoundTag = nbtdata.m_128469_("Metadata");
                        this.offsetX = offsetCompoundTag.m_128451_("WEOffsetX");
                        this.offsetY = offsetCompoundTag.m_128451_("WEOffsetY");
                        this.offsetZ = offsetCompoundTag.m_128451_("WEOffsetZ");
                    } else {
                        CompoundTag blocksCompoundTag = nbtdata.m_128469_("Blocks");
                        blockDataRaw = blocksCompoundTag.m_128463_("Data");
                        palette = blocksCompoundTag.m_128469_("Palette");
                        tileentitynbtlist = blocksCompoundTag.m_128437_("BlockEntities", 10);
                        int[] offsetArray = nbtdata.m_128465_("Offset");
                        this.offsetX = offsetArray[0];
                        this.offsetY = offsetArray[1];
                        this.offsetZ = offsetArray[2];
                    }
                    int index = 0;
                    int i = 0;
                    while (i < blockDataRaw.length) {
                        int value = 0;
                        int varintLength = 0;
                        while (true) {
                            value |= (blockDataRaw[i] & 0x7F) << varintLength++ * 7;
                            if (varintLength > 5) continue;
                            if ((blockDataRaw[i] & 0x80) != 128) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        blockData[index] = value;
                        ++index;
                    }
                    this.palette = new HashMap();
                    for (String k : palette.m_128431_()) {
                        this.palette.put(palette.m_128451_(k), k);
                    }
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                int id = blockData[counter];
                                if (id < 0) {
                                    id *= -1;
                                }
                                BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, id);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int t = 0; t < tileentitynbtlist.size(); ++t) {
                        this.blockEntities.add(tileentitynbtlist.m_128728_(t));
                    }
                    this.parsedCorrectly = true;
                    return;
                }
                case "schematic": {
                    byte[] blockIDs_byte = nbtdata.m_128463_("Blocks");
                    int[] blockIDs = new int[this.size];
                    for (int x = 0; x < blockIDs_byte.length; ++x) {
                        blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                    }
                    byte[] metadata = nbtdata.m_128463_("Data");
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    ListTag tileentitynbtlist = nbtdata.m_128437_("TileEntities", 10);
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                        CompoundTag compound = tileentitynbtlist.m_128728_(i);
                        int i0 = compound.m_128451_("x");
                        int i1 = compound.m_128451_("y");
                        int i2 = compound.m_128451_("z");
                        compound.m_128385_("Pos", new int[]{i0, i1, i2});
                        this.blockEntities.add(compound);
                    }
                    this.offsetX = nbtdata.m_128451_("WEOffsetX");
                    this.offsetY = nbtdata.m_128451_("WEOffsetY");
                    this.offsetZ = nbtdata.m_128451_("WEOffsetZ");
                    this.parsedCorrectly = true;
                    return;
                }
                case "nbt": {
                    ListTag paletteNBTList = nbtdata.m_128437_("palette", 10);
                    this.palette = new HashMap();
                    for (int i = 0; i < paletteNBTList.size(); ++i) {
                        CompoundTag compound = paletteNBTList.m_128728_(i);
                        Object value = compound.m_128461_("Name");
                        if (compound.m_128441_("Properties")) {
                            StringBuilder metaData = new StringBuilder("[");
                            CompoundTag propertyCompound = compound.m_128469_("Properties");
                            for (String propertyKey : propertyCompound.m_128431_()) {
                                if (!metaData.toString().equals("[")) {
                                    metaData.append(",");
                                }
                                metaData.append(propertyKey).append("=").append(propertyCompound.m_128423_(propertyKey));
                            }
                            metaData.append("]");
                            value = (String)value + metaData;
                        }
                        this.palette.put(i, (String)value);
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    ListTag blocksNBTList = nbtdata.m_128437_("blocks", 10);
                    for (int i = 0; i < blocksNBTList.size(); ++i) {
                        CompoundTag compound = blocksNBTList.m_128728_(i);
                        ListTag posList = compound.m_128437_("pos", 3);
                        int i0 = posList.m_128763_(0);
                        int i1 = posList.m_128763_(1);
                        int i2 = posList.m_128763_(2);
                        BlockPos pos = new BlockPos(i0, i1, i2);
                        BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, compound.m_128451_("state"));
                        this.blockObjects[i] = new SchematicBlockObject(pos, state);
                        if (!compound.m_128441_("nbt")) continue;
                        CompoundTag blockEntityCompound = compound.m_128469_("nbt");
                        blockEntityCompound.m_128385_("Pos", new int[]{i0, i1, i2});
                        blockEntityCompound.m_128359_("Id", blockEntityCompound.m_128461_("id"));
                        blockEntityCompound.m_128473_("id");
                        this.blockEntities.add(blockEntityCompound);
                    }
                    ListTag entitiesNBTList = nbtdata.m_128437_("entities", 10);
                    for (int i = 0; i < entitiesNBTList.size(); ++i) {
                        CompoundTag compound = entitiesNBTList.m_128728_(i);
                        CompoundTag entityCompound = compound.m_128469_("nbt");
                        ListTag posList = compound.m_128437_("blockPos", 3);
                        int i0 = posList.m_128763_(0);
                        int i1 = posList.m_128763_(1);
                        int i2 = posList.m_128763_(2);
                        this.entities.add((Pair<BlockPos, CompoundTag>)new Pair((Object)new BlockPos(i0, i1, i2), (Object)entityCompound));
                    }
                    this.offsetX = 0;
                    this.offsetY = 0;
                    this.offsetZ = 0;
                    this.parsedCorrectly = true;
                    return;
                }
            }
        }
        catch (Exception ignored) {
            Constants.LOG.warn("[Collective] Something went wrong while parsing the schematic.");
        }
        Constants.LOG.warn("Can't load {} Schematic file.", (Object)type);
        this.width = 0;
        this.height = 0;
        this.length = 0;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        this.size = 0;
        this.blockObjects = null;
        this.palette = null;
        this.blockEntities = null;
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.m_49803_((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject schematicBlockObject : this.blockObjects) {
            if (!schematicBlockObject.getPosition().equals((Object)pos)) continue;
            return schematicBlockObject.getState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(Registry<Block> blockRegistry, int id) {
        String iblockstateS = this.palette.get(id);
        try {
            return BlockStateParser.m_234691_((HolderLookup)blockRegistry.m_255303_(), (StringReader)new StringReader(iblockstateS), (boolean)false).f_234748_();
        }
        catch (Exception ex) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    public List<CompoundTag> getBlockEntities() {
        return this.blockEntities;
    }

    public List<Pair<BlockPos, CompoundTag>> getEntityRelativePosPairs() {
        return this.entities;
    }

    public CompoundTag getTileEntity(BlockPos pos) {
        for (CompoundTag compound : this.blockEntities) {
            int[] pos1 = compound.m_128465_("Pos");
            if (pos1[0] != pos.m_123341_() || pos1[1] != pos.m_123342_() || pos1[2] != pos.m_123343_()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundTag compoundTag) {
        int[] pos = compoundTag.m_128465_("Pos");
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean wasParsedCorrectly() {
        return this.parsedCorrectly;
    }
}

