/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.AstralObject;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.IntTetrisBagRandom;
import com.nettakrim.spyglass_astronomy.Knowledge;
import com.nettakrim.spyglass_astronomy.Orbit;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpaceRenderingManager;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.StarLine;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import com.nettakrim.spyglass_astronomy.commands.admin_subcommands.StarCountCommand;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpyglassAstronomyClient
implements ClientModInitializer {
    public static final String MODID = "spyglass_astronomy";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Spyglass Astronomy");
    public static boolean ready;
    private static int starCount;
    public static class_310 client;
    public static class_638 world;
    public static ArrayList<Star> stars;
    public static ArrayList<Constellation> constellations;
    public static SpaceRenderingManager spaceRenderingManager;
    public static int editMode;
    public static boolean isDrawingConstellation;
    private static StarLine drawingLine;
    public static Constellation drawingConstellation;
    public static SpaceDataManager spaceDataManager;
    private static boolean lastToggle;
    public static Orbit earthOrbit;
    public static ArrayList<OrbitingBody> orbitingBodies;
    public static float starAngleMultiplier;
    public static float zoom;
    public static Knowledge knowledge;
    public static final class_5251 textColor;
    public static final class_5251 nameTextColor;
    public static final class_5251 buttonTextColor;
    private static boolean spyglassImprovementsIsLoaded;

    public void onInitializeClient() {
        SpyglassAstronomyClient.client = class_310.method_1551();
        SpyglassAstronomyCommands.initialize();
        ClientTickEvents.END_CLIENT_TICK.register(client -> SpyglassAstronomyClient.update());
        spyglassImprovementsIsLoaded = FabricLoader.getInstance().isModLoaded("spyglass-improvements");
    }

    public static void saveSpace() {
        if (spaceDataManager != null) {
            spaceDataManager.saveData();
        }
        if (spaceRenderingManager != null) {
            spaceRenderingManager.saveData();
        }
    }

    public static void discardUnsavedChanges() {
        SpyglassAstronomyClient.loadSpace(world, false);
    }

    public static void loadSpace(class_638 clientWorld, boolean allowSave) {
        if (spaceDataManager != null && allowSave) {
            spaceDataManager.saveData();
        }
        world = clientWorld;
        stars = new ArrayList();
        constellations = new ArrayList();
        orbitingBodies = new ArrayList();
        spaceDataManager = new SpaceDataManager(clientWorld);
        SpyglassAstronomyClient.generateSpace(false);
        StarCountCommand.invalidatedConstellations.clear();
        knowledge = new Knowledge();
        SpyglassAstronomyClient.updateKnowledge();
    }

    public static void generateSpace(boolean reset) {
        class_5819 random = class_5819.method_43049((long)0L);
        SpyglassAstronomyClient.generateStars(random, reset, reset);
        SpyglassAstronomyClient.generatePlanets(random, reset);
        for (Constellation constellation : constellations) {
            constellation.initaliseStarLines();
        }
        spaceRenderingManager = new SpaceRenderingManager();
        spaceRenderingManager.updateSpace(0);
    }

    public static void generateStars(class_5819 random, boolean resetStars, boolean resetConstellations) {
        if (random == null) {
            random = class_5819.method_43049((long)spaceDataManager.getStarSeed());
        } else {
            random.method_43052(spaceDataManager.getStarSeed());
        }
        if (resetStars) {
            stars = new ArrayList();
        }
        if (resetConstellations) {
            constellations = new ArrayList();
            spaceRenderingManager.scheduleConstellationsUpdate();
        }
        int currentStars = 0;
        while (currentStars < starCount) {
            float galaxyCloseness;
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() * 2.0f - 1.0f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float galaxyBias = 0.75f;
            float distance = (posX = galaxyBias * posX * class_3532.method_15379((float)posX) + (1.0f - galaxyBias) * posX) * posX + posY * posY + posZ * posZ;
            if (!((double)distance < 1.0) || !((double)distance > 0.01)) continue;
            distance = class_3532.method_48119((float)distance);
            posX *= distance;
            posY *= distance;
            posZ *= distance;
            float sizeRaw = random.method_43057();
            if (currentStars % 2 == 0 && (galaxyCloseness = 0.12f / (class_3532.method_15379((float)posX) + 0.1f) - 0.2f) > 0.0f) {
                sizeRaw = (1.0f - galaxyCloseness) * sizeRaw + galaxyCloseness * (sizeRaw * sizeRaw / 2.0f);
            }
            float size = 0.15f + sizeRaw * 0.2f;
            float alphaRaw = random.method_43057();
            float alpha = Math.max(class_3532.method_15355((float)(alphaRaw * sizeRaw)), (2.0f * sizeRaw - 1.5f) / (alphaRaw + 0.5f));
            alpha = (alpha + alpha * alpha) / 2.0f;
            int[] color = SpyglassAstronomyClient.generateRandomColor(random, 0.8f, 20.0f, 16, 0, 2.0f);
            float rotationSpeed = random.method_43057() * 2.0f - 1.0f;
            float twinkleSpeed = random.method_43057() * 0.025f + 0.035f;
            stars.add(new Star(currentStars, posX, posY, posZ, size, rotationSpeed, color, alpha, twinkleSpeed));
            ++currentStars;
        }
        ready = true;
        spaceDataManager.loadStarDatas();
    }

    public static void generatePlanets(class_5819 random, boolean reset) {
        float innerRoundAmount;
        if (random == null) {
            random = class_5819.method_43049((long)spaceDataManager.getPlanetSeed());
        } else {
            random.method_43052(spaceDataManager.getPlanetSeed());
        }
        class_5819 lowPriorityRandom = class_5819.method_43049((long)spaceDataManager.getPlanetSeed());
        if (reset) {
            orbitingBodies = new ArrayList();
        }
        IntTetrisBagRandom planetDesignRandom = new IntTetrisBagRandom(random, 3);
        IntTetrisBagRandom cometDesignRandom = new IntTetrisBagRandom(random, 2);
        int innerPlanets = random.method_43048(3) + 1;
        int outerPlanets = random.method_39332(5 - innerPlanets, 8);
        int comets = random.method_39332(4, 6);
        float yearLength = spaceDataManager.getYearLength();
        earthOrbit = SpyglassAstronomyClient.generateRandomOrbit(random, yearLength, 0.05f, 10.0f, 5.0f, true);
        starAngleMultiplier = (yearLength + 1.0f) / yearLength * 360.0f;
        for (innerRoundAmount = 8.0f; (float)innerPlanets >= innerRoundAmount; innerRoundAmount *= 2.0f) {
        }
        int otherHabitable = random.method_39332(0, 8);
        float innerDistanceRange = 1.0f / (float)innerPlanets;
        float[] innerPlanetPeriods = new float[innerPlanets];
        for (float x = 0.0f; x < (float)innerPlanets; x += 1.0f) {
            int randomInnerType;
            float minPeriod = x / (float)innerPlanets;
            float maxPeriod = x / (float)innerPlanets + innerDistanceRange;
            float rawUnRoundedPeriod = random.method_43057();
            float unRoundedPeriod = (1.0f - rawUnRoundedPeriod) * minPeriod + rawUnRoundedPeriod * maxPeriod;
            float period = (float)(class_3532.method_15375((float)(unRoundedPeriod * (innerRoundAmount - 1.0f))) + 1) / innerRoundAmount;
            int y = 0;
            while ((float)y < x) {
                if (innerPlanetPeriods[y] == period) {
                    period += 1.0f / innerRoundAmount;
                }
                ++y;
            }
            if (period == 1.0f) {
                period -= 0.5f / innerRoundAmount;
            }
            innerPlanetPeriods[(int)x] = period;
            OrbitingBody.OrbitingBodyType type = otherHabitable == 0 && x == (float)innerPlanets ? OrbitingBody.OrbitingBodyType.HABITABLE : ((randomInnerType = lowPriorityRandom.method_39332(0, 3)) == 0 && x > (float)(innerPlanets / 2) ? OrbitingBody.OrbitingBodyType.OCEANPLANET : OrbitingBody.OrbitingBodyType.TERRESTIAL);
            Orbit orbit = SpyglassAstronomyClient.generateRandomOrbit(random, period *= yearLength, 0.1f, 20.0f, 10.0f, false);
            SpyglassAstronomyClient.addRandomOrbitingBody(random, lowPriorityRandom, orbit, true, planetDesignRandom, type);
        }
        float[] periodOffsets = new float[]{0.75f, 1.0f, 1.0f, 1.25f};
        for (float x = 0.0f; x < (float)outerPlanets; x += 1.0f) {
            OrbitingBody.OrbitingBodyType type;
            float period = yearLength * (float)(2 << (int)x + 1) * periodOffsets[random.method_43048(periodOffsets.length)];
            float settingsMultiplier = x / 8.0f + 1.0f;
            Orbit orbit = SpyglassAstronomyClient.generateRandomOrbit(random, period, Math.min(0.15f * settingsMultiplier, 0.5f), Math.min(30.0f * settingsMultiplier, 60.0f), Math.min(20.0f * settingsMultiplier, 60.0f), false);
            if (otherHabitable == 1 && x == (float)innerPlanets) {
                type = OrbitingBody.OrbitingBodyType.HABITABLE;
            } else {
                int canBeTerrestial = lowPriorityRandom.method_39332(0, 1);
                if (x <= 4.0f && canBeTerrestial == 0) {
                    int isIcy;
                    int n = isIcy = x == 0.0f ? 1 : lowPriorityRandom.method_39332(0, 1);
                    type = isIcy == 1 ? OrbitingBody.OrbitingBodyType.ICEPLANET : OrbitingBody.OrbitingBodyType.TERRESTIAL;
                } else {
                    int isTerrestial = lowPriorityRandom.method_39332(0, 3);
                    type = isTerrestial == 0 ? OrbitingBody.OrbitingBodyType.ICEPLANET : (x > (float)(outerPlanets / 2) ? OrbitingBody.OrbitingBodyType.ICEGIANT : OrbitingBody.OrbitingBodyType.GASGIANT);
                }
            }
            SpyglassAstronomyClient.addRandomOrbitingBody(random, lowPriorityRandom, orbit, true, planetDesignRandom, type);
        }
        for (int x = 0; x < comets; ++x) {
            float periodRaw = random.method_43057();
            float eccentricity = random.method_43057() * 0.2f + 0.75f;
            float period = Math.max(Math.round(32.0f * (eccentricity - 0.25f + (8.0f * periodRaw - 4.0f))), 2);
            float rotation = random.method_43057() * 360.0f;
            float ascension = random.method_43057() * 180.0f - 90.0f;
            float inclination = random.method_43057() * 180.0f - 90.0f;
            float timeOffset = (float)comets / (float)(x + 1);
            Orbit orbit = new Orbit(period *= yearLength, eccentricity, rotation, ascension, inclination, timeOffset);
            SpyglassAstronomyClient.addRandomOrbitingBody(random, lowPriorityRandom, orbit, false, cometDesignRandom, OrbitingBody.OrbitingBodyType.COMET);
        }
        spaceDataManager.loadOrbitingBodyDatas();
    }

    private static int[] generateRandomColor(class_5819 random, float hueRange, float lightnessRange, int saturationAmount, int forceHue, float forceHueAmount) {
        float offsetRange = 2.0f * hueRange - 2.0f;
        float gradientPos = random.method_43057();
        if (forceHue == -1) {
            gradientPos /= forceHueAmount;
        } else if (forceHue == 1) {
            gradientPos = 1.0f - gradientPos / forceHueAmount;
        }
        float colorRaw = random.method_43057();
        float lightness = 255.0f - colorRaw * lightnessRange;
        float saturationRaw = colorRaw * 256.0f % 1.0f;
        int saturation = (int)(saturationRaw * saturationRaw * (float)saturationAmount);
        if ((float)saturation - lightness > -96.0f || class_3532.method_15379((float)(gradientPos - 0.5f)) < 0.25f) {
            lightness = 255.0f - (255.0f - lightness) / 2.0f;
            saturation = (int)((float)saturation / 1.5f);
        }
        return new int[]{(int)(Math.min(offsetRange * gradientPos - hueRange + 2.0f, 1.0f) * (float)(255 - saturation)), (int)lightness, (int)(Math.min(hueRange - offsetRange * gradientPos, 1.0f) * (float)(255 - saturation))};
    }

    private static void addRandomOrbitingBody(class_5819 random, class_5819 lowPriorityRandom, Orbit orbit, boolean isPlanet, IntTetrisBagRandom decorationRandom, OrbitingBody.OrbitingBodyType type) {
        float size = random.method_43057() + 1.0f;
        float albedo = (random.method_43057() + 1.0f) / 2.0f;
        float rotationSpeed = random.method_43057();
        if (rotationSpeed < 0.5f) {
            rotationSpeed -= 1.0f;
        }
        int decoration = decorationRandom.get();
        int forceMainHue = 0;
        float hueForceAmount = 2.0f;
        if (type == OrbitingBody.OrbitingBodyType.ICEGIANT || type == OrbitingBody.OrbitingBodyType.ICEPLANET || type == OrbitingBody.OrbitingBodyType.OCEANPLANET) {
            forceMainHue = 1;
            albedo = (albedo + 1.0f) / 2.0f;
            hueForceAmount = type == OrbitingBody.OrbitingBodyType.OCEANPLANET ? 3.5f : 2.5f;
        } else {
            int forceNonIcyColor = lowPriorityRandom.method_39332(0, 2);
            if (forceNonIcyColor != 0 && type == OrbitingBody.OrbitingBodyType.TERRESTIAL || type == OrbitingBody.OrbitingBodyType.HABITABLE || type == OrbitingBody.OrbitingBodyType.GASGIANT) {
                forceMainHue = -1;
                hueForceAmount = 3.0f;
            }
        }
        if (!isPlanet) {
            albedo /= 4.0f;
            size = (size + 2.0f) / 12.0f;
        } else if (type == OrbitingBody.OrbitingBodyType.GASGIANT || type == OrbitingBody.OrbitingBodyType.ICEGIANT) {
            size *= 2.0f;
        }
        int[] mainColor = SpyglassAstronomyClient.generateRandomColor(random, 0.1f, 196.0f, 48, forceMainHue, hueForceAmount);
        int[] secondaryColor = SpyglassAstronomyClient.generateRandomColor(lowPriorityRandom, 0.1f, 196.0f, 64, 0, 2.0f);
        orbitingBodies.add(new OrbitingBody(orbit, size, albedo, rotationSpeed, isPlanet, decoration, mainColor, secondaryColor, type));
    }

    private static Orbit generateRandomOrbit(class_5819 random, float period, float maxEccentricity, float maxAscension, float maxInclination, boolean isEarth) {
        float eccentricityRaw = random.method_43057();
        float rotationRaw = random.method_43057();
        float ascensionRaw = random.method_43057() * 2.0f - 1.0f;
        float inclinationRaw = random.method_43057() * 2.0f - 1.0f;
        float eccentricity = eccentricityRaw * maxEccentricity;
        float rotation = rotationRaw * 360.0f;
        float ascension = ascensionRaw * Math.abs(ascensionRaw) * maxAscension;
        float inclination = inclinationRaw * Math.abs(inclinationRaw) * maxInclination;
        float timeOffset = isEarth ? 0.0f : random.method_43057();
        return new Orbit(period, eccentricity, rotation, ascension, inclination, timeOffset);
    }

    public static float getStarAngle() {
        return SpyglassAstronomyClient.getPositionInOrbit(starAngleMultiplier);
    }

    public static float getPositionInOrbit(float scale) {
        long time = world.method_8532();
        return (float)(time / 24000L) % SpyglassAstronomyClient.earthOrbit.period * scale + (float)(time % 24000L) / 24000.0f * scale;
    }

    public static Long getDay() {
        long time = world.method_8532();
        return time / 24000L;
    }

    public static float getDayFraction() {
        long time = world.method_8532();
        return (float)(time % 24000L) / 24000.0f;
    }

    public static void update() {
        if (!ready || SpyglassAstronomyClient.client.field_1724 == null) {
            return;
        }
        boolean spyglassing = SpyglassAstronomyClient.client.field_1724.method_31550();
        boolean toggle = SpyglassAstronomyClient.client.field_1690.field_1871.method_1434();
        if (spyglassing && toggle && !lastToggle) {
            SpyglassAstronomyClient.toggleEditMode();
        }
        if (spyglassing && editMode == 1 && SpyglassAstronomyClient.client.field_1690.field_1886.method_1434()) {
            if (!isDrawingConstellation) {
                SpyglassAstronomyClient.startDrawingConstellation();
            }
        } else if (isDrawingConstellation) {
            SpyglassAstronomyClient.stopDrawingConstellation();
        }
        if (spyglassing && editMode == 2 && SpyglassAstronomyClient.client.field_1690.field_1886.method_1434()) {
            SpyglassAstronomyClient.selectAstralObject();
        }
        if (spyglassing && spaceRenderingManager.starsCurrentlyVisible()) {
            SpyglassAstronomyClient.updateHover();
            if (isDrawingConstellation && spyglassImprovementsIsLoaded) {
                SpyglassAstronomyClient.updateDrawingConstellation();
            }
        }
        if (!SpyglassAstronomyClient.isHoldingSpyglass()) {
            editMode = 0;
        }
        lastToggle = toggle;
    }

    private static void updateHover() {
        if (editMode != 0) {
            AstralObject astralObject;
            if (editMode == 2) {
                astralObject = SpyglassAstronomyClient.getNearestAstralObjectToCursor();
            } else {
                Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
                SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
                astralObject = new AstralObject(SpyglassAstronomyClient.getNearestStar(lookVector.x, lookVector.y, lookVector.z));
            }
            if (AstralObject.isNull(astralObject)) {
                return;
            }
            if (astralObject.isStar) {
                Star star = astralObject.star;
                if (editMode == 2) {
                    if (star.isUnnamed()) {
                        if (star == Star.selected) {
                            SpyglassAstronomyClient.sayActionBar("prompt.name.star", new Object[0]);
                            return;
                        }
                        SpyglassAstronomyClient.sayActionBar("prompt.unnamed.star", new Object[0]);
                    } else {
                        SpyglassAstronomyClient.sayActionBar("prompt.star", star.name);
                    }
                }
                for (Constellation constellation : constellations) {
                    if (!constellation.hasStar(star)) continue;
                    if (constellation.isUnnamed()) {
                        if (constellation == Constellation.selected) {
                            SpyglassAstronomyClient.sayActionBar("prompt.name.constellation", new Object[0]);
                        } else if (star.isUnnamed()) {
                            SpyglassAstronomyClient.sayActionBar("prompt.unnamed.constellation", new Object[0]);
                        } else {
                            SpyglassAstronomyClient.sayActionBar("prompt.unnamed.constellationandstar", star.name);
                        }
                    } else if (star.isUnnamed()) {
                        SpyglassAstronomyClient.sayActionBar("prompt.constellation", constellation.name);
                    } else {
                        SpyglassAstronomyClient.sayActionBar("prompt.constellationandstar", constellation.name, star.name);
                    }
                    return;
                }
            } else {
                String type;
                OrbitingBody orbitingBody = astralObject.orbitingBody;
                String string = type = orbitingBody.isPlanet ? "planet" : "comet";
                if (orbitingBody.isUnnamed()) {
                    if (orbitingBody == OrbitingBody.selected) {
                        SpyglassAstronomyClient.sayActionBar("prompt.name." + type, new Object[0]);
                    } else {
                        SpyglassAstronomyClient.sayActionBar("prompt.unnamed." + type, new Object[0]);
                    }
                } else {
                    SpyglassAstronomyClient.sayActionBar("prompt." + type, orbitingBody.name);
                }
            }
        }
    }

    public static void toggleEditMode() {
        editMode = (editMode + 1) % 3;
    }

    public static void selectAstralObject() {
        Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
        SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
        AstralObject astralObject = SpyglassAstronomyClient.getNearestAstralObjectToCursor();
        if (astralObject == null) {
            return;
        }
        astralObject.select();
    }

    public static void startDrawingConstellation() {
        Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
        SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
        Star star = SpyglassAstronomyClient.getNearestStar(lookVector.x, lookVector.y, lookVector.z);
        if (star == null) {
            return;
        }
        SpyglassAstronomyClient.selectConstellation(star, true);
        drawingLine = new StarLine(star);
        drawingConstellation = new Constellation(drawingLine);
        isDrawingConstellation = true;
        spaceRenderingManager.scheduleConstellationsUpdate();
    }

    public static float getSquaredDistance(float x, float y, float z) {
        return x * x + y * y + z * z;
    }

    public static void stopDrawingConstellation() {
        if (!isDrawingConstellation) {
            return;
        }
        isDrawingConstellation = false;
        Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
        SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
        Star star = SpyglassAstronomyClient.getNearestStar(lookVector.x, lookVector.y, lookVector.z);
        if (star == null || !drawingLine.finishDrawing(star)) {
            spaceRenderingManager.cancelDrawing();
            return;
        }
        SpyglassAstronomyClient.addStarLine(drawingLine, drawingConstellation, true, true);
        SpyglassAstronomyClient.selectConstellation(star, false);
        SpaceDataManager.makeChange();
        spaceRenderingManager.scheduleConstellationsUpdate();
    }

    public static void addStarLine(StarLine newLine, Constellation newConstellation, boolean canRemove, boolean sayFeedback) {
        Constellation target = null;
        int end = constellations.size();
        for (int i = 0; i < end; ++i) {
            Constellation constellation = constellations.get(i);
            if (!constellation.lineIntersects(newLine)) continue;
            if (target != null) {
                for (StarLine line : constellation.getLines()) {
                    target.addLine(line);
                }
                if (sayFeedback) {
                    SpyglassAstronomyClient.say("constellation.merge", target.name, constellation.name);
                }
                if (target.isUnnamed()) {
                    target.name = constellation.name;
                }
                constellations.remove(i);
                break;
            }
            target = constellation;
        }
        if (target != null) {
            if (canRemove) {
                Constellation potentialNew = target.addLineCanRemove(newLine);
                if (potentialNew != null) {
                    if (sayFeedback) {
                        SpyglassAstronomyClient.say("constellation.split", target.name);
                    }
                    constellations.add(potentialNew);
                }
                if (target.getLines().isEmpty()) {
                    if (sayFeedback) {
                        SpyglassAstronomyClient.say("constellation.remove", target.name);
                    }
                    constellations.remove(target);
                }
            } else {
                target.addLine(newLine);
            }
        } else {
            constellations.add(newConstellation);
        }
    }

    public static void updateDrawingConstellation() {
        Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
        SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
        Star star = SpyglassAstronomyClient.getNearestStar(lookVector.x, lookVector.y, lookVector.z);
        if (star == null || drawingLine.hasStar(star.index)) {
            drawingLine.updateDrawing(new Vector3f(lookVector.x * 100.0f, lookVector.y * 100.0f, lookVector.z * 100.0f));
        } else {
            drawingLine.updateDrawing(star.getRenderedPosition());
        }
    }

    public static Vector3f getLookVector() {
        if (SpyglassAstronomyClient.client.field_1724 == null) {
            return new Vector3f(0.0f, 0.0f, 1.0f);
        }
        float pitch = SpyglassAstronomyClient.client.field_1724.method_36455() / 180.0f * (float)Math.PI;
        float yaw = SpyglassAstronomyClient.client.field_1724.method_36454() / 180.0f * (float)Math.PI;
        float x = -class_3532.method_15374((float)yaw);
        float y = -class_3532.method_15374((float)pitch);
        float z = class_3532.method_15362((float)yaw);
        float scale = class_3532.method_15362((float)pitch);
        return new Vector3f(x *= scale, y, z *= scale);
    }

    public static void rotateVectorToStarRotation(Vector3f vector) {
        vector.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        vector.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.getStarAngle() * -1.0f));
        vector.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-45.0f));
    }

    public static void rotateVectorToOrbitingBodyRotation(Vector3f vector) {
        vector.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(SpyglassAstronomyClient.getPositionInOrbit(-360.0f) * (1.0f - 1.0f / SpyglassAstronomyClient.earthOrbit.period) + 180.0f));
    }

    public static Star getNearestStar(float x, float y, float z) {
        float nearestDistance = 5.0f;
        Star nearestStar = null;
        for (Star star : stars) {
            float[] pos = star.getPosition();
            float currentDistance = SpyglassAstronomyClient.getSquaredDistance(x - pos[0], y - pos[1], z - pos[2]);
            if (!(currentDistance < nearestDistance)) continue;
            nearestDistance = currentDistance;
            nearestStar = star;
        }
        if (nearestDistance > 5.0E-4f) {
            return null;
        }
        if (nearestStar.getCurrentNonTwinkledAlpha() < 0.1f) {
            return null;
        }
        return nearestStar;
    }

    public static AstralObject getNearestAstralObjectToCursor() {
        float currentDistance;
        Object pos;
        float nearestDistance = 5.0f;
        Star nearestStar = null;
        OrbitingBody nearestOrbitingBody = null;
        boolean isStar = false;
        Vector3f lookVector = SpyglassAstronomyClient.getLookVector();
        Vector3f rotatedToBody = new Vector3f((Vector3fc)lookVector);
        SpyglassAstronomyClient.rotateVectorToOrbitingBodyRotation(rotatedToBody);
        float x = rotatedToBody.x;
        float y = rotatedToBody.y;
        float z = rotatedToBody.z;
        for (OrbitingBody orbitingBody : orbitingBodies) {
            pos = orbitingBody.getPosition();
            currentDistance = SpyglassAstronomyClient.getSquaredDistance(x - pos.x, y - pos.y, z - pos.z);
            if (!(currentDistance < nearestDistance)) continue;
            nearestDistance = currentDistance;
            nearestOrbitingBody = orbitingBody;
        }
        SpyglassAstronomyClient.rotateVectorToStarRotation(lookVector);
        x = lookVector.x;
        y = lookVector.y;
        z = lookVector.z;
        for (Star star : stars) {
            pos = star.getPosition();
            currentDistance = SpyglassAstronomyClient.getSquaredDistance(x - pos[0], y - pos[1], z - pos[2]);
            if (!(currentDistance < nearestDistance)) continue;
            nearestDistance = currentDistance;
            nearestStar = star;
            isStar = true;
        }
        if (nearestDistance > 5.0E-4f) {
            return null;
        }
        if (isStar) {
            if (nearestStar.getCurrentNonTwinkledAlpha() < 0.1f) {
                return null;
            }
            return new AstralObject(nearestStar);
        }
        if (nearestOrbitingBody.getCurrentNonTwinkledAlpha() < 0.1f) {
            return null;
        }
        return new AstralObject(nearestOrbitingBody);
    }

    public static float getHeight() {
        if (SpyglassAstronomyClient.client.field_1724 == null) {
            return 128.0f;
        }
        return (float)SpyglassAstronomyClient.client.field_1724.method_19538().field_1351;
    }

    public static void selectConstellation(Star star, boolean clear) {
        Constellation oldSelected = Constellation.selected;
        Constellation.deselect();
        for (Constellation constellation : constellations) {
            if (!constellation.hasStar(star)) continue;
            constellation.select();
            break;
        }
        if (!clear && Constellation.selected == null && oldSelected != null) {
            oldSelected.select();
        }
    }

    private static void say(class_2561 text) {
        if (SpyglassAstronomyClient.client.field_1724 == null) {
            return;
        }
        SpyglassAstronomyClient.client.field_1724.method_7353(text, false);
    }

    public static void say(String key, Object ... args) {
        SpyglassAstronomyClient.say((class_2561)class_2561.method_43471((String)"spyglass_astronomy.say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)class_2561.method_43469((String)("spyglass_astronomy." + key), (Object[])args).method_10862(class_2583.field_24360.method_27703(textColor))));
    }

    public static void sayText(class_2561 text) {
        SpyglassAstronomyClient.say((class_2561)class_2561.method_43471((String)"spyglass_astronomy.say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852(text));
    }

    public static void longSay(class_2561 text) {
        SpyglassAstronomyClient.say((class_2561)class_2561.method_43471((String)"spyglass_astronomy.longsay").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852(text));
    }

    public static void sayActionBar(String key, Object ... args) {
        if (SpyglassAstronomyClient.client.field_1724 == null) {
            return;
        }
        SpyglassAstronomyClient.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)("spyglass_astronomy." + key), (Object[])args), true);
    }

    public static void updateKnowledge() {
        knowledge.updateStarKnowledge(constellations, stars);
        int planets = 0;
        int comets = 0;
        for (OrbitingBody orbitingBody : orbitingBodies) {
            if (orbitingBody.isPlanet) {
                ++planets;
                continue;
            }
            ++comets;
        }
        knowledge.updateOrbitKnowledge(orbitingBodies, planets, comets);
    }

    public static boolean isHoldingSpyglass() {
        if (!ready || SpyglassAstronomyClient.client.field_1724 == null) {
            return false;
        }
        return SpyglassAstronomyClient.client.field_1724.method_6047().method_31574(class_1802.field_27070) || SpyglassAstronomyClient.client.field_1724.method_6079().method_31574(class_1802.field_27070);
    }

    public static void setStarCount(int count) {
        starCount = count;
    }

    public static int getStarCount() {
        return starCount;
    }

    static {
        starCount = 1024;
        lastToggle = false;
        textColor = class_5251.method_27717((int)0xAAAAAA);
        nameTextColor = class_5251.method_27717((int)11767539);
        buttonTextColor = class_5251.method_27717((int)4322180);
    }
}

