/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpaceRenderingManager {
    private final class_291 starsBuffer = new class_291(class_291.class_8555.field_44793);
    private boolean starsReady = false;
    private final class_291 constellationsBuffer = new class_291(class_291.class_8555.field_44793);
    private boolean constellationsReady = false;
    private final class_291 drawingConstellationsBuffer = new class_291(class_291.class_8555.field_44793);
    private boolean drawingReady = false;
    private final class_291 planetsBuffer = new class_291(class_291.class_8555.field_44793);
    private boolean planetsReady = false;
    private static float heightScale = 1.0f;
    public static boolean constellationsVisible;
    public static boolean starsVisible;
    public static boolean orbitingBodiesVisible;
    public static boolean oldStarsVisible;
    public static boolean starsAlwaysVisible;
    private float starVisibility;
    private boolean constellationsNeedsUpdate = true;
    private File data = null;
    private Path storagePath;
    private final String fileName;

    public SpaceRenderingManager() {
        this.storagePath = SpyglassAstronomyClient.client.field_1697.toPath().resolve(".spyglass_astronomy");
        this.fileName = String.valueOf(this.storagePath) + "/rendering.txt";
        constellationsVisible = true;
        starsVisible = true;
        orbitingBodiesVisible = true;
        oldStarsVisible = false;
        starsAlwaysVisible = false;
        if (Files.exists(this.storagePath, new LinkOption[0])) {
            this.data = new File(this.fileName);
            if (this.data.exists()) {
                this.loadData();
            }
        }
    }

    private void loadData() {
        try {
            if (this.data.createNewFile()) {
                return;
            }
            Scanner scanner = new Scanner(this.data);
            String s = scanner.nextLine();
            scanner.close();
            constellationsVisible = this.charTrue(s, 0);
            starsVisible = this.charTrue(s, 1);
            orbitingBodiesVisible = this.charTrue(s, 2);
            oldStarsVisible = this.charTrue(s, 3);
            starsAlwaysVisible = this.charTrue(s, 4);
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to load data");
        }
    }

    private boolean charTrue(String s, int index) {
        return index < s.length() && s.charAt(index) == '1';
    }

    public void saveData() {
        try {
            if (this.data == null) {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
                this.data = new File(this.fileName);
            }
            FileWriter writer = new FileWriter(this.data);
            String s = (constellationsVisible ? "1" : "0") + (starsVisible ? "1" : "0") + (orbitingBodiesVisible ? "1" : "0") + (oldStarsVisible ? "1" : "0") + (starsAlwaysVisible ? "1" : "0");
            writer.write(s);
            writer.close();
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to save data");
        }
    }

    public void updateSpace(int ticks) {
        class_746 player;
        SpaceRenderingManager.updateHeightScale();
        if (!(Constellation.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Constellation.deselect();
            this.constellationsNeedsUpdate = true;
        }
        if (this.constellationsNeedsUpdate) {
            this.updateConstellations();
            this.constellationsNeedsUpdate = false;
        }
        if (!(Star.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Star.deselect();
        }
        if (!(OrbitingBody.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            OrbitingBody.deselect();
        }
        this.updateStars(ticks);
        this.updateOrbits(ticks);
    }

    public void scheduleConstellationsUpdate() {
        this.constellationsNeedsUpdate = true;
    }

    public void cancelDrawing() {
        this.drawingReady = false;
    }

    private void updateConstellations() {
        this.drawingReady = SpyglassAstronomyClient.isDrawingConstellation;
        if (SpyglassAstronomyClient.constellations.isEmpty()) {
            this.constellationsReady = false;
            return;
        }
        class_287 constellationsBufferBuilder = class_289.method_1348().method_1349();
        constellationsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            constellation.setVertices(constellationsBufferBuilder, false);
        }
        this.constellationsBuffer.method_1353();
        this.constellationsBuffer.method_1352(constellationsBufferBuilder.method_1326());
        this.constellationsReady = true;
    }

    private void updateStars(int ticks) {
        if (SpyglassAstronomyClient.stars.isEmpty()) {
            this.starsReady = false;
            return;
        }
        class_287 starBufferBuilder = class_289.method_1348().method_1349();
        starBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Star star : SpyglassAstronomyClient.stars) {
            star.update(ticks);
            star.setVertices(starBufferBuilder);
        }
        this.starsBuffer.method_1353();
        this.starsBuffer.method_1352(starBufferBuilder.method_1326());
        this.starsReady = true;
    }

    private void updateOrbits(int ticks) {
        if (SpyglassAstronomyClient.orbitingBodies.isEmpty()) {
            orbitingBodiesVisible = false;
            return;
        }
        class_287 planetsBufferBuilder = class_289.method_1348().method_1349();
        planetsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Long day = SpyglassAstronomyClient.getDay();
        float dayFraction = SpyglassAstronomyClient.getDayFraction();
        Vector3f referencePosition = SpyglassAstronomyClient.earthOrbit.getRotatedPositionAtGlobalTime(day, dayFraction, true);
        Vector3f normalisedReferencePosition = new Vector3f((Vector3fc)referencePosition);
        normalisedReferencePosition.normalize();
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            orbitingBody.update(ticks, referencePosition, normalisedReferencePosition, day, dayFraction);
            orbitingBody.setVertices(planetsBufferBuilder);
        }
        this.planetsBuffer.method_1353();
        this.planetsBuffer.method_1352(planetsBufferBuilder.method_1326());
        this.planetsReady = true;
    }

    private void updateDrawingConstellation() {
        class_287 drawingConstellationsBufferBuilder = class_289.method_1348().method_1349();
        drawingConstellationsBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        SpyglassAstronomyClient.drawingConstellation.setVertices(drawingConstellationsBufferBuilder, true);
        this.drawingConstellationsBuffer.method_1353();
        this.drawingConstellationsBuffer.method_1352(drawingConstellationsBufferBuilder.method_1326());
    }

    public void Render(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta) {
        float f = this.starVisibility = starsAlwaysVisible ? 1.0f : SpyglassAstronomyClient.world.method_23787(tickDelta) * (1.0f - SpyglassAstronomyClient.world.method_8430(tickDelta));
        if (this.starVisibility > 0.0f) {
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.getStarAngle()));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            float colorScale = this.starVisibility + Math.min(heightScale, 0.5f);
            RenderSystem.setShaderColor((float)colorScale, (float)colorScale, (float)colorScale, (float)this.starVisibility);
            class_758.method_23792();
            if (starsVisible && this.starsReady) {
                this.starsBuffer.method_1353();
                this.starsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                class_291.method_1354();
            }
            if (constellationsVisible) {
                if (this.constellationsReady) {
                    this.constellationsBuffer.method_1353();
                    this.constellationsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                    class_291.method_1354();
                }
                if (SpyglassAstronomyClient.isDrawingConstellation || this.drawingReady) {
                    this.updateDrawingConstellation();
                    this.drawingConstellationsBuffer.method_1353();
                    this.drawingConstellationsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                }
            }
            if (orbitingBodiesVisible && this.planetsReady) {
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40718.rotationDegrees(SpyglassAstronomyClient.getPositionInOrbit(360.0f) * (1.0f - 1.0f / SpyglassAstronomyClient.earthOrbit.period) + 180.0f));
                this.planetsBuffer.method_1353();
                this.planetsBuffer.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
                class_291.method_1354();
            }
        }
    }

    public static void updateHeightScale() {
        heightScale = class_3532.method_15363((float)((SpyglassAstronomyClient.getHeight() - 32.0f) / 256.0f), (float)0.0f, (float)1.0f);
    }

    public static float getHeightScale() {
        return heightScale;
    }

    public boolean starsCurrentlyVisible() {
        return this.starVisibility > 0.0f;
    }
}

