/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.RotationalManager;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import org.joml.Vector3f;

public class Telescope
extends Weapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);
    int lastFireTick = 0;

    public Telescope(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    public void tick() {
        class_1309 pilot;
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
        --this.lastFireTick;
        if (this.lastFireTick == 0 && (pilot = this.getEntity().method_5642()) != null) {
            pilot.method_5783(class_3417.field_26973, 1.0f, 1.0f);
        }
    }

    @Override
    public void fire(Vector3f direction) {
    }

    @Override
    public void clientFire(int index) {
        class_1309 pilot = this.getEntity().method_5642();
        assert (pilot != null);
        if (this.lastFireTick <= 0) {
            pilot.method_5783(class_3417.field_26972, 1.0f, 1.0f);
        }
        this.lastFireTick = 2;
    }

    public Boolean isScoping() {
        return this.lastFireTick > 0;
    }

    @Override
    public <T extends VehicleEntity> void setAnimationVariables(T entity, float time) {
        super.setAnimationVariables(entity, time);
        float tickDelta = time % 1.0f;
        BBAnimationVariables.set("pitch", (float)((double)this.rotationalManager.getPitch(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("yaw", (float)((double)this.rotationalManager.getYaw(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("roll", (float)((double)this.rotationalManager.getRoll(tickDelta) / Math.PI * 180.0));
    }
}

