/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.Lists;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record NestedSlotReferenceImpl(class_1309 entity, String slotName, int initialHolderSlot, List<Integer> innerSlotIndices) implements SlotReference
{
    public NestedSlotReferenceImpl {
        if (initialHolderSlot < -1) {
            throw new IndexOutOfBoundsException("A given Nested Slot Reference was attempted to be created with a negative initialHolderSlot value!");
        }
    }

    @Override
    public String createSlotPath() {
        StringBuilder slotPath = new StringBuilder(SlotReference.super.createSlotPath());
        List<Integer> innerSlotIndices = this.innerSlotIndices();
        for (int i = 0; i < innerSlotIndices.size(); ++i) {
            Integer innerIndex = innerSlotIndices.get(i);
            slotPath.append("/nest_").append(i).append("_").append(innerIndex);
        }
        return slotPath.toString();
    }

    @Override
    public boolean isValid() {
        if (!SlotReference.super.isValid()) {
            return false;
        }
        class_1799 selectedStack = SlotReference.super.getStack();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, class_1799> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return false;
            }
            selectedStack = (class_1799)innerData.right();
        }
        return true;
    }

    @Override
    public int slot() {
        return this.initialHolderSlot();
    }

    @Override
    @Nullable
    public class_1799 getStack() {
        class_1799 selectedStack = SlotReference.super.getStack();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, class_1799> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return null;
            }
            selectedStack = (class_1799)innerData.right();
        }
        return selectedStack;
    }

    @Nullable
    private static Pair<NestLayer, class_1799> tryAndGet(class_1799 holderStack, int innerIndex) {
        Accessory accessory = AccessoriesAPI.getAccessory(holderStack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        AccessoryNest accessoryNest = (AccessoryNest)accessory;
        return Pair.of((Object)new NestLayer(accessoryNest, holderStack, innerIndex), (Object)accessoryNest.getInnerStacks(holderStack).get(innerIndex));
    }

    @Override
    public boolean setStack(class_1799 stack) {
        class_1799 selectedStack = SlotReference.super.getStack();
        if (selectedStack == null) {
            return false;
        }
        ArrayList<NestLayer> layerStack = new ArrayList<NestLayer>();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, class_1799> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return false;
            }
            layerStack.add((NestLayer)innerData.first());
            selectedStack = (class_1799)innerData.right();
        }
        class_1799 innerStack = stack;
        for (NestLayer layer : Lists.reverse(layerStack)) {
            if (!layer.setStack(innerStack)) {
                return false;
            }
            innerStack = layer.holderStack();
        }
        SlotReference.super.setStack(innerStack);
        return true;
    }

    private record NestLayer(AccessoryNest accessoryNest, class_1799 holderStack, int index) {
        private boolean setStack(class_1799 innerStack) {
            return this.accessoryNest.setInnerStack(this.holderStack, this.index, innerStack);
        }
    }
}

