/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3542;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5797;
import net.minecraft.class_7923;

public abstract class ProcessingRecipe
implements class_1860<class_1263> {
    protected final class_3956<?> type;
    protected final class_2960 id;
    protected final Category category;
    protected final class_1856 ingredient;
    protected final class_1799 result;
    protected final int time;

    protected ProcessingRecipe(class_3956<?> type, class_2960 id, Category category, class_1856 ingredient, class_1799 result, int time) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public Category getCategory() {
        return this.category;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.result;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return this.ingredient.method_8093(container.method_5438(0));
    }

    public class_1799 method_8116(class_1263 container, class_5455 access) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static Builder builder(Category category, class_1856 input, class_1799 output, int processTime, Serializer<? extends ProcessingRecipe> serializer) {
        return new Builder(category, input, output, processTime, serializer);
    }

    public static enum Category implements class_3542
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final class_3542.class_7292<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public void toNetwork(class_2540 buf) {
            buf.method_10788(this.name, 6);
        }

        public static Category fromNetwork(class_2540 buf) {
            return Category.byName(buf.method_10800(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.method_47920(name, (Enum)MISC);
        }

        static {
            CODEC = class_3542.method_28140(Category::values);
        }
    }

    public static class Builder
    implements class_5797 {
        private final Category category;
        protected final class_1856 ingredient;
        protected final class_1799 result;
        protected final int time;
        protected final Serializer<? extends ProcessingRecipe> serializer;
        protected final class_161.class_162 advancement = class_161.class_162.method_51698();

        private Builder(Category category, class_1856 ingredient, class_1799 result, int time, Serializer<? extends ProcessingRecipe> serializer) {
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.time = time;
            this.serializer = serializer;
        }

        public class_5797 method_33530(String name, class_184 instance) {
            this.advancement.method_709(name, instance);
            return this;
        }

        public class_5797 method_33529(@Nullable String var1) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public class_1792 method_36441() {
            return this.result.method_7909();
        }

        public void method_17972(Consumer<class_2444> consumer, class_2960 id) {
            this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
            consumer.accept(new Result(id, this.category, this.ingredient, this.result, this.time, this.serializer, this.advancement, id.method_45138("recipes/")));
        }
    }

    public static abstract class Serializer<T extends ProcessingRecipe>
    implements class_1865<T> {
        protected final Factory<T> factory;
        protected final int defaultTime;

        public Serializer(Factory<T> factory, int defaultTime) {
            this.factory = factory;
            this.defaultTime = defaultTime;
        }

        public abstract void toJson(JsonObject var1, Result var2);

        public T fromNetwork(class_2960 id, class_2540 buf) {
            Category category = Category.fromNetwork(buf);
            class_1856 ingredient = class_1856.method_8086((class_2540)buf);
            class_1799 result = buf.method_10819();
            int time = buf.method_10816();
            return this.factory.create(id, category, ingredient, result, time);
        }

        public void toNetwork(class_2540 buf, T recipe) {
            ((ProcessingRecipe)recipe).category.toNetwork(buf);
            ((ProcessingRecipe)recipe).ingredient.method_8088(buf);
            buf.method_10793(((ProcessingRecipe)recipe).result);
            buf.method_10804(((ProcessingRecipe)recipe).time);
        }
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        protected ItemWithCount(class_3956<?> type, class_2960 id, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, id, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        extends com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe$Serializer<T> {
            public Serializer(Factory<T> factory, int defaultTime) {
                super(factory, defaultTime);
            }

            @Override
            public void toJson(JsonObject object, Result result) {
                object.addProperty("category", result.category.method_15434());
                object.add("ingredient", result.ingredient.method_8089());
                String id = class_7923.field_41178.method_10221((Object)result.result.method_7909()).toString();
                int count = result.result.method_7947();
                if (count == 1) {
                    object.addProperty("result", id);
                } else {
                    JsonObject itemObject = new JsonObject();
                    itemObject.addProperty("item", id);
                    itemObject.addProperty("count", (Number)count);
                    object.add("result", (JsonElement)itemObject);
                }
                object.addProperty("time", (Number)result.time);
            }

            public T fromJson(class_2960 id, JsonObject object) {
                Category category = Category.byName(class_3518.method_15253((JsonObject)object, (String)"category", (String)"misc"));
                class_1856 input = Utils.getIngredient(object, "ingredient");
                class_1799 output = Utils.getItemStack(object, "result");
                int processTime = class_3518.method_15282((JsonObject)object, (String)"time", (int)this.defaultTime);
                return this.factory.create(id, category, input, output, processTime);
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        protected Item(class_3956<?> type, class_2960 id, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, id, category, ingredient, result, time);
        }

        public static ProcessingRecipe from(final class_1874 recipe, class_5455 access) {
            return new ProcessingRecipe(recipe.method_17716(), recipe.method_8114(), Category.FOOD, (class_1856)recipe.method_8117().get(0), recipe.method_8110(access), recipe.method_8167()){

                public class_1865<?> method_8119() {
                    return recipe.method_8119();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        extends com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe$Serializer<T> {
            public Serializer(Factory<T> factory, int defaultTime) {
                super(factory, defaultTime);
            }

            @Override
            public void toJson(JsonObject object, Result result) {
                String id = class_7923.field_41178.method_10221((Object)result.result.method_7909()).toString();
                object.addProperty("category", result.category.method_15434());
                object.add("ingredient", result.ingredient.method_8089());
                object.addProperty("result", id);
                object.addProperty("time", (Number)result.time);
            }

            public T fromJson(class_2960 id, JsonObject object) {
                Category category = Category.byName(class_3518.method_15253((JsonObject)object, (String)"category", (String)"misc"));
                class_1856 ingredient = Utils.getIngredient(object, "ingredient");
                class_2960 resultId = new class_2960(class_3518.method_15265((JsonObject)object, (String)"result"));
                class_1792 item = (class_1792)class_7923.field_41178.method_17966(resultId).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(resultId)));
                int time = class_3518.method_15282((JsonObject)object, (String)"time", (int)this.defaultTime);
                return this.factory.create(id, category, ingredient, new class_1799((class_1935)item), time);
            }
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final Category category;
        private final class_1856 ingredient;
        private final class_1799 result;
        private final int time;
        private final Serializer<? extends ProcessingRecipe> serializer;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 id, Category category, class_1856 ingredient, class_1799 result, int time, Serializer<? extends ProcessingRecipe> serializer, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.time = time;
            this.serializer = serializer;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject object) {
            this.serializer.toJson(object, this);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.serializer;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(class_2960 var1, Category var2, class_1856 var3, class_1799 var4, int var5);
    }
}

