/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.image.ImagePresets;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageUpdatePainting;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class DoorMatScreen
extends class_465<DoorMatMenu> {
    private static final class_2960 TEXTURE = Utils.resource("textures/gui/container/door_mat.png");
    private static final PaletteImage[] PRESETS = new PaletteImage[]{ImagePresets.BLANK, ImagePresets.HEART, ImagePresets.MUSHROOM, ImagePresets.FORWARD_ARROW, ImagePresets.WARNING, ImagePresets.HOUSE, ImagePresets.CRISSCROSS, ImagePresets.STRIPES, ImagePresets.WAVES_PATTERN, ImagePresets.GEM_PATTERN, ImagePresets.ABSTRACT_PATTERN, ImagePresets.SWIRL_PATTERN};
    private PaletteImage image;
    private Tool currentTool = Tool.PENCIL;
    @Nullable
    private Tool activeTool;
    private int selectedColourIndex = 1;
    private int currentPreset = 0;

    public DoorMatScreen(DoorMatMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = 134;
        this.field_2779 = 103;
        this.image = PRESETS[0].copy();
    }

    protected void method_25426() {
        super.method_25426();
        class_4185 previousPreset = (class_4185)this.method_37063((class_364)new IconButton(this.field_2776 + this.field_2792 / 2 - 45 - 20, this.field_2800 + 14, 0, 20, btn -> {
            this.image = PRESETS[Math.floorMod(--this.currentPreset, PRESETS.length)].copy();
        }));
        previousPreset.method_47400(class_7919.method_47407((class_2561)Utils.translation("gui", "previous_preset", new Object[0])));
        class_4185 nextPreset = (class_4185)this.method_37063((class_364)new IconButton(this.field_2776 + this.field_2792 / 2 + 45, this.field_2800 + 14, 10, 20, btn -> {
            this.image = PRESETS[Math.floorMod(++this.currentPreset, PRESETS.length)].copy();
        }));
        nextPreset.method_47400(class_7919.method_47407((class_2561)Utils.translation("gui", "next_preset", new Object[0])));
        for (int i = 1; i < PaletteImage.COLOURS.length; ++i) {
            this.method_37063((class_364)new ColourButton(this.field_2776 + (i - 1) * 8 + 7, this.field_2800 + 65, i));
        }
        this.method_37063((class_364)new ToolButton(this.field_2776 + 6, this.field_2800 + 77, 30, 10, Tool.PENCIL));
        this.method_37063((class_364)new ToolButton(this.field_2776 + 29, this.field_2800 + 77, 40, 10, Tool.ERASER));
        this.method_37063((class_364)new ToolButton(this.field_2776 + 52, this.field_2800 + 77, 50, 10, Tool.FILL));
        this.method_37063((class_364)class_4185.method_46430((class_2561)Utils.translation("gui", "save", new Object[0]), var1 -> Network.getPlay().sendToServer((IMessage)new MessageUpdatePainting(this.image))).method_46433(this.field_2776 + 75, this.field_2800 + 77).method_46437(53, 20).method_46431());
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        this.method_25420(graphics);
        graphics.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (int y = 0; y < this.image.getHeight(); ++y) {
            for (int x = 0; x < this.image.getWidth(); ++x) {
                int pixelStart = this.field_2776 + 39 + x * 4;
                int pixelEnd = pixelStart + 4;
                int pixelTop = this.field_2800 + 4 + y * 4;
                int pixelBottom = pixelTop + 4;
                graphics.method_25294(pixelStart, pixelTop, pixelEnd, pixelBottom, PaletteImage.COLOURS[this.image.get(x, y)]);
            }
        }
        if (this.activeTool != null) {
            this.activateTool(mouseX, mouseY, true);
        }
    }

    private boolean activateTool(double mouseX, double mouseY, boolean continuous) {
        int start = this.field_2776 + 39;
        int end = start + 56;
        int top = this.field_2800 + 4;
        int bottom = top + 40;
        if (mouseX >= (double)start && mouseX < (double)end && mouseY >= (double)top && mouseY < (double)bottom) {
            int x = (int)((mouseX - (double)start) / 4.0);
            int y = (int)((mouseY - (double)top) / 4.0);
            if (this.currentTool.getFunction().apply(this.image, x, y, this.selectedColourIndex) && !continuous) {
                this.activeTool = this.currentTool;
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.activateTool(mouseX, mouseY, false)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.activeTool != null && button == 0) {
            this.activeTool = null;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private static enum Tool {
        PENCIL((image, x, y, colourIndex) -> {
            image.set(x, y, colourIndex);
            return true;
        }),
        ERASER((image, x, y, colourIndex) -> {
            image.set(x, y, 0);
            return true;
        }),
        FILL((image, x, y, colourIndex) -> {
            int fillColourIndex = image.get(x, y);
            if (fillColourIndex == colourIndex) {
                return false;
            }
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.offer(Pair.of((Object)x, (Object)y));
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.poll();
                int pixelX = (Integer)pair.left();
                int pixelY = (Integer)pair.right();
                image.set(pixelX, pixelY, colourIndex);
                if (pixelY - 1 >= 0 && image.get(pixelX, pixelY - 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY - 1)));
                }
                if (pixelY + 1 < image.getHeight() && image.get(pixelX, pixelY + 1) == fillColourIndex) {
                    queue.offer(Pair.of((Object)pixelX, (Object)(pixelY + 1)));
                }
                if (pixelX - 1 >= 0 && image.get(pixelX - 1, pixelY) == fillColourIndex) {
                    queue.offer(Pair.of((Object)(pixelX - 1), (Object)pixelY));
                }
                if (pixelX + 1 >= image.getWidth() || image.get(pixelX + 1, pixelY) != fillColourIndex) continue;
                queue.offer(Pair.of((Object)(pixelX + 1), (Object)pixelY));
            }
            return false;
        });

        private final ToolFunction function;

        private Tool(ToolFunction function) {
            this.function = function;
        }

        public ToolFunction getFunction() {
            return this.function;
        }
    }

    private class ColourButton
    extends ComputerButton {
        private final int colourIndex;

        protected ColourButton(int x, int y, int colourIndex) {
            super(8, 8, class_5244.field_39003, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.selectedColourIndex = colourIndex;
            });
            this.method_48229(x, y);
            this.colourIndex = colourIndex;
            this.setBackgroundColour(PaletteImage.COLOURS[colourIndex]);
            this.setBackgroundHighlightColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineColour(PaletteImage.COLOURS[colourIndex]);
            this.setOutlineHighlightColour(-1);
        }

        public boolean method_49606() {
            return super.method_49606() || DoorMatScreen.this.selectedColourIndex == this.colourIndex;
        }

        public int getColourIndex() {
            return this.colourIndex;
        }
    }

    private class ToolButton
    extends IconButton {
        private final Tool tool;

        public ToolButton(int x, int y, int u, int v, Tool tool) {
            super(x, y, u, v, btn -> {
                com$mrcrayfish$furniture$refurbished$client$gui$screen$DoorMatScreen$this.currentTool = tool;
            });
            this.tool = tool;
        }

        public boolean method_49606() {
            return super.method_49606() || DoorMatScreen.this.currentTool == this.tool;
        }
    }

    @FunctionalInterface
    private static interface ToolFunction {
        public boolean apply(PaletteImage var1, int var2, int var3, int var4);
    }
}

