/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.furniture.refurbished.block.StoveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends ElectricityModuleLootBlockEntity
implements IProcessingBlock,
IHeatingSource,
IPowerSwitch,
IHomeControlDevice,
class_1275,
class_1737 {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    public static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROGRESS_1 = 2;
    public static final int DATA_PROGRESS_2 = 3;
    public static final int DATA_PROGRESS_3 = 4;
    public static final int DATA_TOTAL_PROGRESS_1 = 5;
    public static final int DATA_TOTAL_PROGRESS_2 = 6;
    public static final int DATA_TOTAL_PROGRESS_3 = 7;
    protected final ImmutableList<CookingSpace> spaces;
    protected boolean enabled;
    protected boolean processing;
    protected int totalProcessingTime;
    protected int processingTime;
    protected WeakReference<ICookingBlock> cookingBlockRef;
    protected boolean sync;
    @Nullable
    protected StoveContainer container;
    protected final class_3913 data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.getCookingSpaces((int)0).bakingTime, value -> {});
        builder.add(3, () -> this.getCookingSpaces((int)1).bakingTime, value -> {});
        builder.add(4, () -> this.getCookingSpaces((int)2).bakingTime, value -> {});
        builder.add(5, () -> this.getCookingSpaces((int)0).totalBakingTime, value -> {});
        builder.add(6, () -> this.getCookingSpaces((int)1).totalBakingTime, value -> {});
        builder.add(7, () -> this.getCookingSpaces((int)2).totalBakingTime, value -> {});
    });

    public StoveBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.STOVE.get(), pos, state);
    }

    public StoveBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 6);
        this.spaces = (ImmutableList)class_156.method_656(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)3);
            IntStream.range(0, 3).forEach(i -> builder.add((Object)new CookingSpace(i, i + 3, (class_3956<? extends ProcessingRecipe>)((class_3956)ModRecipeTypes.OVEN_BAKING.get()))));
            return builder.build();
        });
    }

    private CookingSpace getCookingSpaces(int index) {
        return (CookingSpace)this.spaces.get(index);
    }

    @Override
    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return OUTPUT_SLOTS;
        }
        return INPUT_SLOTS;
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public boolean requiresEnergy() {
        return false;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            time = block.getTimeToCook();
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        boolean changed = false;
        if (this.processingTime == 0 && time > this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStartCooking();
            }
            this.processing = true;
            this.sync();
            changed = true;
        } else if (time == 0 && time < this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStopCooking();
            }
            this.processing = false;
            this.sync();
            changed = true;
        }
        if (this.processingTime != time) {
            this.processingTime = time;
            changed = true;
        }
        if (changed) {
            this.method_5431();
        }
    }

    @Override
    public void onCompleteProcess() {
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            block.onCompleteCooking();
            this.processing = false;
            this.method_5431();
            this.sync();
        }
    }

    @Override
    public boolean canProcess() {
        if (!this.isNodePowered() || !this.enabled) {
            return false;
        }
        ICookingBlock block = this.getCookingBlock();
        return block != null && block.canCook();
    }

    @Nullable
    public ICookingBlock getCookingBlock() {
        class_3218 serverLevel;
        class_2586 entity;
        class_1937 class_19372;
        if (this.cookingBlockRef != null) {
            ICookingBlock block = (ICookingBlock)this.cookingBlockRef.get();
            if (block != null && !block.getBlockEntity().method_11015()) {
                return block;
            }
            this.cookingBlockRef = null;
        }
        if ((class_19372 = this.field_11863) instanceof class_3218 && (entity = (serverLevel = (class_3218)class_19372).method_8321(this.field_11867.method_10084())) instanceof ICookingBlock) {
            ICookingBlock cookingBlock = (ICookingBlock)entity;
            this.cookingBlockRef = new WeakReference<ICookingBlock>(cookingBlock);
            return cookingBlock;
        }
        return null;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        stove.processTick();
        stove.spaces.forEach(IProcessingBlock::processTick);
        if (stove.sync) {
            BlockEntityHelper.sendCustomUpdate((class_2586)stove, stove.method_16887());
            stove.sync = false;
        }
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "stove", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return Services.MENU.createStoveMenu(windowId, playerInventory, (class_1263)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public void onOpen(class_1937 level, class_2338 pos, class_2680 state) {
        class_243 center = class_243.method_24953((class_2382)this.field_11867).method_43206(((class_2350)state.method_11654((class_2769)StoveBlock.DIRECTION)).method_10153(), 0.5);
        level.method_43128(null, center.field_1352, center.field_1351, center.field_1350, (class_3414)ModSounds.BLOCK_STOVE_OPEN.get(), class_3419.field_15245, 1.0f, 0.9f + 0.1f * level.field_9229.method_43057());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(class_1937 level, class_2338 pos, class_2680 state) {
        class_243 center = class_243.method_24953((class_2382)this.field_11867).method_43206(((class_2350)state.method_11654((class_2769)StoveBlock.DIRECTION)).method_10153(), 0.5);
        level.method_43128(null, center.field_1352, center.field_1351, center.field_1350, (class_3414)ModSounds.BLOCK_STOVE_CLOSE.get(), class_3419.field_15245, 1.0f, 0.9f + 0.1f * level.field_9229.method_43057());
        this.setDoorState(state, false);
    }

    private void setDoorState(class_2680 state, boolean open) {
        class_1937 level = this.method_10997();
        if (level != null) {
            level.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)StoveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public boolean isHeating() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)StoveBlock.LIT) && (Boolean)state.method_11654((class_2769)StoveBlock.LIT) != false;
    }

    public void onDestroyed(class_2338 pos) {
        class_2586 class_25862;
        class_1937 level;
        if (this.isProcessing() && (level = this.method_10997()) != null && (class_25862 = level.method_8321(pos.method_10084())) instanceof ICookingBlock) {
            ICookingBlock cooking = (ICookingBlock)class_25862;
            cooking.onStopCooking();
        }
    }

    public void onNeighbourChanged() {
        this.container = null;
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.container = null;
    }

    @Nullable
    public class_1278 getContainer() {
        if (this.container == null) {
            class_2586 class_25862;
            ICookingBlock cookingBlock = this.getCookingBlock();
            if (cookingBlock != null && (class_25862 = cookingBlock.getBlockEntity()) instanceof class_1263) {
                class_1263 cookingContainer = (class_1263)class_25862;
                this.container = new StoveContainer(this, cookingBlock, cookingContainer);
            }
        } else if (!this.container.isValid()) {
            this.container = null;
        }
        return this.container != null ? this.container : this;
    }

    protected void sync() {
        this.sync = true;
    }

    @Override
    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("Processing", 1)) {
            this.processing = tag.method_10577("Processing");
        }
        if (tag.method_10573("TotalProcessingTime", 3)) {
            this.totalProcessingTime = tag.method_10550("TotalProcessingTime");
        }
        if (tag.method_10573("ProcessingTime", 3)) {
            this.processingTime = tag.method_10550("ProcessingTime");
        }
        if (tag.method_10573("Enabled", 1)) {
            this.enabled = tag.method_10577("Enabled");
        }
        this.readCookingSpaces(tag);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("Processing", this.processing);
        tag.method_10569("TotalProcessingTime", this.totalProcessingTime);
        tag.method_10569("ProcessingTime", this.processingTime);
        tag.method_10556("Enabled", this.enabled);
        this.writeCookingSpaces(tag);
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)StoveBlock.POWERED) && (Boolean)state.method_11654((class_2769)StoveBlock.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)StoveBlock.POWERED)) {
            state = (class_2680)state.method_11657((class_2769)StoveBlock.POWERED, (Comparable)Boolean.valueOf(powered));
        }
        if (state.method_28498((class_2769)StoveBlock.LIT)) {
            state = (class_2680)state.method_11657((class_2769)StoveBlock.LIT, (Comparable)Boolean.valueOf(powered && this.enabled));
        }
        this.field_11863.method_8652(this.field_11867, state, 3);
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.isNodePowered() && this.enabled)), 3);
        this.method_5431();
        this.sync();
    }

    @Override
    public class_2338 getDevicePos() {
        return this.field_11867;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.method_5431();
        BlockEntityHelper.sendCustomUpdate((class_2586)this, this.method_16887());
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.method_5431();
        BlockEntityHelper.sendCustomUpdate((class_2586)this, this.method_16887());
    }

    @Override
    public class_2561 getDeviceName() {
        if (this.method_16914()) {
            return this.method_5797();
        }
        return this.method_17823();
    }

    private class_2487 writeCookingSpaces(class_2487 compound) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.spaces.size(); ++i) {
            class_2487 tag = new class_2487();
            ((CookingSpace)this.spaces.get(i)).writeToTag(tag);
            tag.method_10569("Position", i);
            list.add((Object)tag);
        }
        compound.method_10566("CookingSpaces", (class_2520)list);
        return compound;
    }

    private void readCookingSpaces(class_2487 compound) {
        if (compound.method_10573("CookingSpaces", 9)) {
            class_2499 list = compound.method_10554("CookingSpaces", 10);
            list.forEach(nbt -> {
                int position;
                class_2487 tag = (class_2487)nbt;
                if (tag.method_10573("Position", 3) && (position = tag.method_10550("Position")) >= 0 && position < this.spaces.size()) {
                    ((CookingSpace)this.spaces.get(position)).readFromTag(tag);
                }
            });
        }
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 stack : this.items) {
            contents.method_7400(stack);
        }
    }

    protected class CookingSpace
    implements IProcessingBlock {
        private final int inputIndex;
        private final int outputIndex;
        private final class_1863.class_7266<class_1263, ? extends ProcessingRecipe> inputRecipeCache;
        private int totalBakingTime;
        private int bakingTime;

        public CookingSpace(int inputIndex, int outputIndex, class_3956<? extends ProcessingRecipe> recipeType) {
            this.inputIndex = inputIndex;
            this.outputIndex = outputIndex;
            this.inputRecipeCache = class_1863.method_42302(recipeType);
        }

        @Override
        public int getEnergy() {
            return 0;
        }

        @Override
        public void addEnergy(int energy) {
        }

        @Override
        public boolean requiresEnergy() {
            return false;
        }

        @Override
        public int retrieveEnergy(boolean simulate) {
            return 0;
        }

        @Override
        public int updateAndGetTotalProcessingTime() {
            int time = 0;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe();
            if (optional.isPresent()) {
                time = Math.max(time, optional.get().getTime());
            }
            if (this.totalBakingTime != time) {
                this.totalBakingTime = time;
                StoveBlockEntity.this.method_5431();
            }
            return this.totalBakingTime;
        }

        @Override
        public int getTotalProcessingTime() {
            return this.totalBakingTime;
        }

        @Override
        public int getProcessingTime() {
            return this.bakingTime;
        }

        @Override
        public void setProcessingTime(int time) {
            this.bakingTime = time;
            StoveBlockEntity.this.method_5431();
        }

        @Override
        public void onCompleteProcess() {
            class_1799 stack = StoveBlockEntity.this.method_5438(this.inputIndex);
            if (!stack.method_7960()) {
                class_1792 remainingItem = stack.method_7914() == 1 ? stack.method_7909().method_7858() : null;
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                class_1937 level = Objects.requireNonNull(StoveBlockEntity.this.method_10997());
                class_1799 result = optional.map(recipe -> recipe.method_8110(level.method_30349())).orElse(class_1799.field_8037);
                stack.method_7934(1);
                if (!result.method_7960()) {
                    class_1799 copy = result.method_7972();
                    class_1799 outputStack = StoveBlockEntity.this.method_5438(this.outputIndex);
                    if (outputStack.method_7960()) {
                        StoveBlockEntity.this.method_5447(this.outputIndex, copy);
                    } else if (class_1799.method_31577((class_1799)copy, (class_1799)outputStack) && outputStack.method_7947() + copy.method_7947() <= outputStack.method_7914()) {
                        outputStack.method_7933(copy.method_7947());
                        StoveBlockEntity.this.method_5431();
                    }
                    if (remainingItem != null) {
                        if (stack.method_7960()) {
                            StoveBlockEntity.this.method_5447(this.inputIndex, new class_1799((class_1935)remainingItem));
                        } else {
                            class_243 pos = StoveBlockEntity.this.method_11016().method_46558().method_1031(0.0, 0.5, 0.0);
                            class_1264.method_5449((class_1937)StoveBlockEntity.this.field_11863, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)new class_1799((class_1935)remainingItem));
                        }
                    }
                }
            }
        }

        @Override
        public boolean canProcess() {
            if (!StoveBlockEntity.this.isNodePowered() || !StoveBlockEntity.this.enabled) {
                return false;
            }
            class_1799 stack = StoveBlockEntity.this.method_5438(this.inputIndex);
            if (!stack.method_7960()) {
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                if (optional.isEmpty()) {
                    return false;
                }
                class_1937 level = Objects.requireNonNull(StoveBlockEntity.this.method_10997());
                class_1799 result = optional.get().method_8110(level.method_30349());
                return this.canOutput(result);
            }
            return false;
        }

        private boolean canOutput(class_1799 result) {
            if (result.method_7960()) {
                return false;
            }
            class_1799 stack = StoveBlockEntity.this.method_5438(this.outputIndex);
            return stack.method_7960() || class_1799.method_31577((class_1799)result, (class_1799)stack) && stack.method_7947() + result.method_7947() <= stack.method_7914();
        }

        private Optional<? extends ProcessingRecipe> getRecipe() {
            class_1799 stack = StoveBlockEntity.this.method_5438(this.inputIndex);
            if (!stack.method_7960()) {
                class_1937 level = StoveBlockEntity.this.method_10997();
                return this.inputRecipeCache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(level));
            }
            return Optional.empty();
        }

        public void writeToTag(class_2487 tag) {
            tag.method_10569("CookingTime", this.bakingTime);
            tag.method_10569("TotalCookingTime", this.totalBakingTime);
        }

        public void readFromTag(class_2487 tag) {
            if (tag.method_10573("CookingTime", 3)) {
                this.bakingTime = tag.method_10550("CookingTime");
            }
            if (tag.method_10573("TotalCookingTime", 3)) {
                this.totalBakingTime = tag.method_10550("TotalCookingTime");
            }
        }
    }
}

