/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3956;

public abstract class ProcessingContainerBlockEntity
extends BasicLootBlockEntity
implements IProcessingBlock {
    protected static final int[] NO_SLOTS = new int[0];
    private final class_1863.class_7266<class_1263, ? extends ProcessingRecipe> inputRecipeCache;
    private final class_1863.class_7266<class_1263, ? extends ProcessingRecipe>[] processRecipeCache;
    private final class_1863.class_7266<class_1263, ? extends ProcessingRecipe> outputRecipeCache;
    protected int totalProcessingTime;
    protected int processingTime;
    protected int energy;

    public ProcessingContainerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int containerSize, class_3956<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, containerSize);
        this.inputRecipeCache = class_1863.method_42302(recipeType);
        this.processRecipeCache = this.createCacheArray(this.getInputSlots().length, () -> class_1863.method_42302((class_3956)recipeType));
        this.outputRecipeCache = class_1863.method_42302(recipeType);
    }

    protected abstract int[] getInputSlots();

    protected abstract int[] getOutputSlots();

    protected abstract int[] getEnergySlots();

    protected boolean shouldProcessAll() {
        return false;
    }

    protected int getEnergyFor(class_1799 stack) {
        return 0;
    }

    protected void onConsumeEnergy(class_1799 stack) {
    }

    protected boolean handleProcessed(class_1799 stack) {
        return false;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
        this.method_5431();
    }

    @Override
    public boolean requiresEnergy() {
        return this.getEnergySlots().length > 0;
    }

    @Override
    public int retrieveEnergy(boolean consume) {
        int[] slots;
        for (int slot : slots = this.getEnergySlots()) {
            int energy;
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || (energy = this.getEnergyFor(stack)) <= 0) continue;
            if (consume) {
                this.onConsumeEnergy(stack);
                stack.method_7934(1);
                this.method_5431();
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            Optional<? extends ProcessingRecipe> optional;
            int slot = slots[i];
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !(optional = this.getRecipe(this.processRecipeCache[i], stack)).isPresent()) continue;
            time = Math.max(time, optional.get().getTime());
            if (!this.shouldProcessAll()) break;
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
            this.method_5431();
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        if (time != this.processingTime) {
            this.method_5431();
        }
        this.processingTime = time;
    }

    @Override
    public boolean canProcess() {
        return this.canProcessInput();
    }

    protected final boolean canProcessInput() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            if (optional.isEmpty()) {
                return false;
            }
            class_1799 result = optional.get().method_8110(this.field_11863.method_30349());
            if (!this.canOutput(stack, result)) {
                return false;
            }
            if (this.shouldProcessAll()) continue;
            return true;
        }
        return !this.isInputEmpty();
    }

    @Override
    public void onCompleteProcess() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            class_1792 remainingItem = stack.method_7909().method_7858();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            class_1799 result = optional.map(recipe -> recipe.method_8110(this.field_11863.method_30349())).orElse(class_1799.field_8037);
            stack.method_7934(1);
            if (!result.method_7960()) {
                class_1799 copy = result.method_7972();
                if (!this.handleProcessed(copy)) {
                    this.pushOutput(copy);
                    this.method_5431();
                }
                if (remainingItem != null) {
                    if (stack.method_7960()) {
                        this.method_5447(slot, new class_1799((class_1935)remainingItem));
                    } else {
                        class_243 pos = this.method_11016().method_46558().method_1031(0.0, 0.5, 0.0);
                        class_1264.method_5449((class_1937)this.field_11863, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)new class_1799((class_1935)remainingItem));
                    }
                }
            }
            if (this.shouldProcessAll()) continue;
            return;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, ProcessingContainerBlockEntity processor) {
        processor.processTick();
    }

    protected boolean canOutput(class_1799 input, class_1799 result) {
        int[] slots;
        if (result.method_7960()) {
            return false;
        }
        int count = 0;
        for (int slot : slots = this.getOutputSlots()) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) {
                return true;
            }
            if (this.isOutputInput(slot) && input.method_7909().method_7858() == null) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)result, (class_1799)stack)) continue;
            count += stack.method_7914() - stack.method_7947();
        }
        return count >= result.method_7947();
    }

    protected boolean isOutputInput(int outputSlotIndex) {
        return this.method_5444() == 1 && this.slotsContains(this.getInputSlots(), outputSlotIndex);
    }

    protected void pushOutput(class_1799 result) {
        int[] slots;
        for (int slot : slots = this.getOutputSlots()) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) {
                this.method_5447(slot, result);
                return;
            }
            if (!class_1799.method_31577((class_1799)result, (class_1799)stack) || stack.method_7947() >= stack.method_7914()) continue;
            int count = Math.min(result.method_7947(), stack.method_7914() - stack.method_7947());
            stack.method_7933(count);
            result.method_7934(count);
            if (!result.method_7960()) continue;
            return;
        }
    }

    protected boolean isInputEmpty() {
        int[] slots;
        for (int slot : slots = this.getInputSlots()) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            return false;
        }
        return slots.length > 0;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(class_1863.class_7266<class_1263, ? extends ProcessingRecipe> cache, class_1799 stack) {
        return cache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863));
    }

    public boolean isRecipe(class_1799 stack) {
        return this.inputRecipeCache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).isPresent();
    }

    @Override
    public boolean method_5437(int slotIndex, class_1799 stack) {
        if (this.slotsContains(this.getInputSlots(), slotIndex)) {
            return this.isSlotInsertable(slotIndex);
        }
        if (this.slotsContains(this.getEnergySlots(), slotIndex)) {
            return this.getEnergyFor(stack) > 0 && this.isSlotInsertable(slotIndex);
        }
        return false;
    }

    public boolean method_49104(class_1263 container, int slotIndex, class_1799 stack) {
        if (this.slotsContains(this.getOutputSlots(), slotIndex)) {
            if (this.isOutputInput(slotIndex)) {
                return this.getRecipe(this.outputRecipeCache, stack).isEmpty();
            }
            return true;
        }
        return false;
    }

    protected boolean slotsContains(int[] slots, int slotIndex) {
        for (int slot : slots) {
            if (slot != slotIndex) continue;
            return true;
        }
        return false;
    }

    protected class_1863.class_7266<class_1263, ? extends ProcessingRecipe>[] createCacheArray(int size, Supplier<class_1863.class_7266<class_1263, ? extends ProcessingRecipe>> fill) {
        class_1863.class_7266[] array = new class_1863.class_7266[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = fill.get();
        }
        return array;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("MaxProcessTime", 3)) {
            this.totalProcessingTime = tag.method_10550("MaxProcessTime");
        }
        if (tag.method_10573("ProcessTime", 3)) {
            this.processingTime = tag.method_10550("ProcessTime");
        }
        if (tag.method_10573("Energy", 3)) {
            this.energy = tag.method_10550("Energy");
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("MaxProcessTime", this.totalProcessingTime);
        tag.method_10569("ProcessTime", this.processingTime);
        tag.method_10569("Energy", this.energy);
    }
}

