/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class FryingPanBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    public FryingPanBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 baseShape = class_2248.method_9541((double)2.5, (double)1.0, (double)2.5, (double)13.5, (double)4.0, (double)13.5);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_243 clickVec = context.method_17698().method_1020(class_243.method_24954((class_2382)pos));
        class_2350 forward = context.method_8042();
        class_2350 right = forward.method_10170();
        double side = right.method_10166().method_10172(clickVec.field_1352, 0.0, clickVec.field_1350);
        side = Math.abs((double)Math.min(right.method_10171().method_10181(), 0) + side);
        forward = side < 0.5 ? forward.method_10153() : forward;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)DIRECTION, (Comparable)forward)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(this.isHeated(context.method_8045(), pos)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 class_25862;
        if (!level.method_8608() && result.method_17780() != class_2350.field_11033 && (class_25862 = level.method_8321(pos)) instanceof FryingPanBlockEntity) {
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)class_25862;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574((class_1792)ModItems.SPATULA.get())) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound(level, pos, 0.1875);
            } else if (!stack.method_7960()) {
                if (fryingPan.placeContents(level, stack, player.method_5735().method_10161()) && !player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
            } else {
                fryingPan.removeContents();
            }
        }
        return class_1269.field_5812;
    }

    public boolean method_9558(class_2680 state, class_4538 reader, class_2338 pos) {
        return reader.method_8321(pos.method_10074()) instanceof IHeatingSource;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIT});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FryingPanBlockEntity(pos, state);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 source) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof FryingPanBlockEntity) {
            double posZ;
            double posY;
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)class_25862;
            if (!fryingPan.method_5438(0).method_7960() && fryingPan.isFlippingNeeded()) {
                double posX = (double)pos.method_10263() + 0.35 + 0.3 * level.field_9229.method_43058();
                posY = (double)pos.method_10264() + 0.15;
                posZ = (double)pos.method_10260() + 0.35 + 0.3 * level.field_9229.method_43058();
                level.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.125, (double)pos.method_10260() + 0.5, 0.0, 0.05, 0.0);
                fryingPan.spawnSteam(level, posX, posY, posZ);
            }
            if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && fryingPan.method_5438(0).method_7960() && source.method_43048(2) == 0) {
                double posX = (double)pos.method_10263() + 0.3 + 0.4 * level.field_9229.method_43058();
                posY = (double)pos.method_10264() + 0.15;
                posZ = (double)pos.method_10260() + 0.3 + 0.4 * level.field_9229.method_43058();
                level.method_8406((class_2394)ModParticleTypes.STEAM.get(), posX, posY, posZ, 0.0, 0.05, 0.0);
            }
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.method_8608()) {
            return FryingPanBlock.createTicker(type, (class_2591)ModBlockEntities.FRYING_PAN.get(), FryingPanBlockEntity::clientTick);
        }
        return null;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 $$4, boolean $$5) {
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (this.isHeated(level, pos)) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (!this.isHeated(level, pos)) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private boolean isHeated(class_1937 level, class_2338 pos) {
        IHeatingSource source;
        class_2586 class_25862;
        class_2338 belowPos = pos.method_10074();
        return level != null && (class_25862 = level.method_8321(belowPos)) instanceof IHeatingSource && (source = (IHeatingSource)class_25862).isHeating();
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715);
    }

    public static void playSpatulaScoopSound(class_1937 level, class_2338 pos, double offset) {
        class_243 vec = class_243.method_24955((class_2382)pos);
        level.method_43128(null, vec.field_1352, vec.field_1351 + offset, vec.field_1350, (class_3414)ModSounds.ITEM_SPATULA_SCOOP.get(), class_3419.field_15248, 1.0f, 1.0f);
    }
}

